﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using SportsStore.Domain.Entities;

namespace SportsStore.Infrastructure
{
    public class CartModelBinder : IModelBinder
    {
        private const string cartSessionKey = "_cart";

        public object BindModel(ControllerContext controllerContext,
                                ModelBindingContext bindingContext)
        {
            // Niektóre łączniki modelu mogą aktualizować właściwości istniejących 
            // instancji modelu. W tym przypadku nie jest to potrzebne - jest on używany
            // wyłącznie do dostarczania parametrów metod akcji. 
            if (bindingContext.Model != null)
                throw new InvalidOperationException("Nie można modyfikować instancji");

            // Zwróć obiekt Cart z Session[] (tworząc w razie potrzeby) 
            Cart cart = (Cart)controllerContext.HttpContext.Session[cartSessionKey];
            if (cart == null)
            {
                cart = new Cart();
                controllerContext.HttpContext.Session[cartSessionKey] = cart;
            }
            return cart;
        }
    } 

}