﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using r12Controller.Infrastructure;
using System.Xml.Linq;
using r12Controller.Models;

namespace r12Controller.Controllers
{
    public class ExampleController : Controller
    {
        //
        // GET: /Example/

        public object Index()
        {
            return "To jest zwykły tekst";
        }

        public FileResult AnnualReport()
        {

            string filename = @"d:\rob\AnnualReport.pdf";
            string contentType = "application/pdf";
            string downloadName = "AnnualReport2011.pdf";

            return File(filename, contentType, downloadName);
        }


        public RssActionResult RSS()
        {

            StoryLink[] stories = GetAllStories();
            return new RssActionResult<StoryLink>("Moje artykuły", stories, e =>
            {
                return new XElement("item",
                    new XAttribute("title", e.Title),
                    new XAttribute("description", e.Description),
                    new XAttribute("link", e.Url));
            });
        }

        private StoryLink[] GetAllStories()
        {
            List<StoryLink> arr = new List<StoryLink>();

            StoryLink s = new StoryLink();
            s.Title = "Pierwsza przykładowa historia";
            s.Description = "To jest trzecia przykładowa historia";
            s.Url = "/Story/1";
            arr.Add(s);

            s = new StoryLink();
            s.Title = "Pierwsza przykładowa historia";
            s.Description = "To jest trzecia przykładowa historia";
            s.Url = "/Story/1";
            arr.Add(s);

            s = new StoryLink();
            s.Title = "Pierwsza przykładowa historia";
            s.Description = "To jest trzecia przykładowa historia";
            s.Url = "/Story/1";
            arr.Add(s);

            return arr.ToArray();
        } 

    }
}
