﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Ninject;
using System.Web.Routing;
using Ninject.Modules;
using SportsStore.Domain.Abstract;
using SportsStore.Domain.Concrete;
using System.Configuration;
using SportsStore.Domain.Services;

namespace SportsStore.Infrastructure
{
    public class NinjectControllerFactory : DefaultControllerFactory
    {
        // "kernel" Ninject jest obiektem, który dostarcza instancje obiektów 
        private IKernel kernel = new StandardKernel(new SportsStoreServices());

        // ASP.NET MVC wywołuje tę metodę w celu pobrania kontrolera dla każdego żądania 
        protected override IController GetControllerInstance(RequestContext context,
                                                             Type controllerType)
        {
            if (controllerType == null)
                return null;
            return (IController)kernel.Get(controllerType);
        }

        // Określa sposób odwzorowania abstrakcyjnych typów usługowych na konkretne implementacje 
        private class SportsStoreServices : NinjectModule
        {
            public override void Load()
            {
                Bind<IProductsRepository>()
                    .To<SqlProductsRepository>()
                    .WithConstructorArgument("connectionString",
                        ConfigurationManager.ConnectionStrings["AppDb"].ConnectionString
                    );
                Bind<IOrderSubmitter>().To<FakeOrderSubmitter>();
            } 

        }
    }
}