﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using SportsStore.Infrastructure;
using SportsStore.Domain.Entities;

namespace SportsStore
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class MvcApplication : System.Web.HttpApplication
    {
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.MapRoute(null,
                "", // Tylko pusty URL (czyli ~/) 
                new
                {
                    controller = "Products",
                    action = "List",
                    category = (string)null,
                    page = 1
                }
            );

            routes.MapRoute(null,
                "Strona{page}", // Pasuje do ~/Strona2, ~/Strona123, ale nie do ~/StronaXYZ 
                new { controller = "Products", action = "List", category = (string)null },
                new { page = @"\d+" } // Ograniczenie: page musi być wartością numeryczną 
            );

            routes.MapRoute(null,
                "{category}", // Pasuje do ~/Tenis lub ~/CokolwiekBezUkośnika 
                new { controller = "Products", action = "List", page = 1 }
            );

            routes.MapRoute(null,
                "{category}/Strona{page}", // Pasuje do ~/Tenis/Strona567
                new { controller = "Products", action = "List" }, // Domyślnie 
                new { page = @"\d+" } // Ograniczenie: page musi być wartością numeryczną 
            );

            routes.MapRoute(null, "{controller}/{action}"); 

        }

        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();

            RegisterRoutes(RouteTable.Routes);
            ControllerBuilder.Current.SetControllerFactory(new NinjectControllerFactory());
            ModelBinders.Binders.Add(typeof(Cart), new CartModelBinder());
        }
    }
}