﻿using System.Web.Mvc;
using SportsStore.Domain.Abstract;
using SportsStore.Domain.Concrete;
using System.Linq;
using System.ComponentModel;
using SportsStore.Models;

namespace SportsStore.WebUI.Controllers
{
    public class ProductsController : Controller
    {
        public int PageSize = 3; // Później to zmienimy 
        private IProductsRepository productsRepository;

        public ProductsController(IProductsRepository productsRepository)
        {
            this.productsRepository = productsRepository;
        }


        public ViewResult List(string category, [DefaultValue(1)] int page)
        {
            var productsToShow = (category == null)
                 ? productsRepository.Products
                 : productsRepository.Products.Where(x => x.Category == category);
            var viewModel = new ProductsListViewModel
            {
                Products = productsToShow.Skip((page - 1) * PageSize).Take(PageSize).ToList(),
                PagingInfo = new PagingInfo
                {
                    CurrentPage = page,
                    ItemsPerPage = PageSize,
                    TotalItems = productsToShow.Count()
                },
                CurrentCategory = category
            };
            return View(viewModel);
        }

        public FileContentResult GetImage(int productId)
        {
            var product = productsRepository.Products.First(x => x.ProductID == productId);
            return File(product.ImageData, product.ImageMimeType);
        } 

    } 

} 

