﻿using SportsStore.Domain.Abstract;
using SportsStore.Domain.Entities;
using System.Data.Linq;
using System.Linq;

namespace SportsStore.Domain.Concrete
{
    public class SqlProductsRepository : IProductsRepository
    {
        private Table<Product> productsTable;
        public SqlProductsRepository(string connectionString)
        {
            productsTable = (new DataContext(connectionString)).GetTable<Product>();
        }

        public IQueryable<Product> Products
        {
            get { return productsTable; }
        }

        public void SaveProduct(Product product)
        {
            // Jeżeli jest to nowy produkt, dołącz go do DataContext 
            if (product.ProductID == 0)
                productsTable.InsertOnSubmit(product);
            else if (productsTable.GetOriginalEntityState(product) == null)
            {
                // Zmieniamy istniejący produkt, ale nie jest on dołączony do  
                // tego kontekstu danych, więc dołącz go i wykryj zmiany 
                productsTable.Attach(product);
                productsTable.Context.Refresh(RefreshMode.KeepCurrentValues, product);
            }

            productsTable.Context.SubmitChanges();
        }

        public void DeleteProduct(Product product)
        {
            productsTable.DeleteOnSubmit(product);
            productsTable.Context.SubmitChanges();
        } 

    }
}
