﻿using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs repozytorium kategorii.
    /// </summary>
    public interface ICategoryRepository : IRepository<Category>
    {
        /// <summary>
        /// Pobranie wszystkich kategorii usług.
        /// </summary>
        /// <returns>Kategorie usług.</returns>
        IQueryable<Category> GetAllCategories();

        /// <summary>
        /// Pobranie kategorii usługi po identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator kategorii usług.</param>
        /// <returns>Kategoria usług o podanym identyfikatorze.</returns>
        Category GetCategoryById(int id);

        /// <summary>
        /// Pobranie wszystkich kategorii komentarzy.
        /// </summary>
        /// <returns>Kategorie komentarzy.</returns>
        IQueryable<CommentCategory> GetAllCommentCategories();

        /// <summary>
        /// Pobranie kategorii komentarzy po identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator kategorii komentarzy.</param>
        /// <returns>Kategoria komentarzy o podanym identyfikatorze.</returns>
        CommentCategory GetCommentCategoryById(int id);
    }
}
