﻿using System;
using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs repozytorium usług.
    /// </summary>
    public interface IServiceRepository : IRepository<Service>
    {
        /// <summary>
        /// Pobranie usługi o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator usługi.</param>
        /// <returns>Usługa o podanym identyfikatorze.</returns>
        Service GetServiceById(int id);

        /// <summary>
        /// Sprawdzenie, czy użytkownik o podanym identyfikatorze dodał usługę/-i.
        /// </summary>
        /// <param name="userId">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik dodał usługę/-i.</returns>
        bool HasUserServices(int userId);

        /// <summary>
        /// Pobranie wszystkich usług.
        /// </summary>
        /// <returns>Wszystkie usługi.</returns>
        IQueryable<ServiceViewModel> GetAllService();

        /// <summary>
        /// Pobranie aktywnych usług.
        /// </summary>
        /// <returns>Aktywne usługi.</returns>
        IQueryable<ServiceViewModel> GetActiveService();

        /// <summary>
        /// Pobranie usługi o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator usługi.</param>
        /// <returns>Usługa o podanym identyfikatorze.</returns>
        ServiceViewModel GetServiceViewModelById(int id);

        /// <summary>
        /// Pobieranie aktywnych usług usługodawcy o podanym identyfikatorze użytkownika.
        /// </summary>
        /// <param name="userId">Identyfikator użytkownika.</param>
        /// <returns>Aktywne usługi użytkownika o podanym identyfikatorze użytkownika.</returns>
        IQueryable<ServiceViewModel> GetActiveServicesByUserId(int userId);

        /// <summary>
        /// Pobranie nowych usług.
        /// </summary>
        /// <returns>Pięć nowych usług.</returns>
        IQueryable<ServiceViewModel> GetNewServices();
    }
}
