﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace PortalUslug.Models
{
    [MetadataType(typeof(CategoryMetaData))]
    public class Category
    {
        public Category()
        {
            this.Services = new HashSet<Service>();
        }

        public int Id { get; set; }
        public string Name { get; set; }

        public virtual ICollection<Service> Services { get; set; }
    }

    public class CategoryMetaData
    {
        [Required(ErrorMessage = "Nazwa jest wymagana.")]
        [Display(Name = "Nazwa")]
        public string Name { get; set; }
    }
}
