﻿using Planner.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace Planner.Controllers
{
    public class TasksController : ApiController
    {
        static private TaskRepository _repository;

        public TasksController()
        {
            _repository = new TaskRepository();
        }

        // GET api/values
        public IEnumerable<Task> Get()
        {
            var tasks = _repository.Get();
            return tasks;
        }

        // GET api/values/5
        public Task Get(int id)
        {
            Task task = _repository.Get(id);
            if (task == null)
            {
                throw new HttpResponseException(new HttpResponseMessage(HttpStatusCode.NotFound));
            }
            return task;
        }

        // POST api/values
        public HttpResponseMessage Post(Task task)
        {
            task = _repository.Add(task);
            var response = Request.CreateResponse<Task>(HttpStatusCode.Created, task);
            string uri = Url.Route(null, new { id = task.Id });
            response.Headers.Location = new Uri(Request.RequestUri, uri);
            return response;
        }

        // DELETE api/values/5
        public HttpResponseMessage Delete(int id)
        {
            _repository.Remove(id);
            return new HttpResponseMessage(HttpStatusCode.NoContent);
        }
    }
}
