﻿using System;
using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Klasa repozytorium kategorii.
    /// </summary>
    public class CategoryRepository : ICategoryRepository
    {
        /// <summary>
        /// Obiekt klasy kontekstowej.
        /// </summary>
        private PortalUslugContext _db;

        /// <summary>
        /// Konstruktor repozytorium kategorii.
        /// </summary>
        public CategoryRepository()
        {
            _db = new PortalUslugContext();
        }

        #region Kategorie usług

        /// <summary>
        /// Pobranie wszystkich kategorii usług.
        /// </summary>
        /// <returns>Kategorie usług.</returns>
        public IQueryable<Category> GetAllCategories()
        {
            return _db.Categories;
        }

        /// <summary>
        /// Pobranie kategorii usługi po identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator kategorii usług.</param>
        /// <returns>Kategoria usług o podanym identyfikatorze.</returns>
        public Category GetCategoryById(int id)
        {
            return _db.Categories.Find(id);
        }

        /// <summary>
        /// Dodanie kategorii.
        /// </summary>
        /// <param name="category">Dodawana kategoria.</param>
        public void Add(Category category)
        {
            _db.Categories.Add(category);
        }

        #endregion

        #region Kategorie komentarzy

        /// <summary>
        /// Pobranie wszystkich kategorii komentarzy.
        /// </summary>
        /// <returns>Kategorie komentarzy.</returns>
        public IQueryable<CommentCategory> GetAllCommentCategories()
        {
            return _db.CommentCategories;
        }

        /// <summary>
        /// Pobranie kategorii komentarzy po identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator kategorii komentarzy.</param>
        /// <returns>Kategoria komentarzy o podanym identyfikatorze.</returns>
        public CommentCategory GetCommentCategoryById(int id)
        {
            return _db.CommentCategories.Find(id);
        }

        /// <summary>
        /// Dodanie kategorii.
        /// </summary>
        /// <param name="category">Dodawana kategoria.</param>
        public void Add(CommentCategory category)
        {
            _db.CommentCategories.Add(category);
        }

        #endregion

        /// <summary>
        /// Zapisanie zmian.
        /// </summary>
        public void SaveChanges()
        {
            _db.SaveChanges();
        }

        /// <summary>
        /// Usunięcie kategorii.
        /// </summary>
        /// <param name="category">Usuwana kategoria.</param>
        public void Delete(Category category)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Usunięcie kategorii.
        /// </summary>
        /// <param name="category">Usuwana kategoria.</param>
        public void Delete(CommentCategory category)
        {
            throw new NotImplementedException();
        }
    }
}