﻿using System;
using System.ComponentModel.DataAnnotations;

namespace PortalUslug.Models
{
    [MetadataType(typeof(CommentMetaData))]
    public class Comment
    {
        public int Id { get; set; }
        public DateTime Date { get; set; }
        public string Content { get; set; }
        public string IPAddress { get; set; }
        public int UserId { get; set; }
        public int ServiceId { get; set; }
        public int CommentCategoryId { get; set; }

        public virtual Service Services { get; set; }
        public virtual CommentCategory CommentCategory { get; set; }
    }

    public class CommentMetaData
    {
        [Required(ErrorMessage = "Treść jest wymagana.")]
        [Display(Name = "Treść komentarza")]
        [StringLength(200, ErrorMessage = "Treść komentarza może mieć maksymalnie 200 znaków.")]
        public string Content { get; set; }

        [DataType(DataType.DateTime)]
        [Display(Name = "Data dodania")]
        public DateTime Date { get; set; }

        [Display(Name = "Kategoria")]
        public string CommentCategory { get; set; }
    }

    public class CommentViewModel
    {
        [ScaffoldColumn(false)]
        public int Id { get; set; }

        [Required(ErrorMessage = "Treść jest wymagana.")]
        [Display(Name = "Treść komentarza")]
        [StringLength(200, ErrorMessage = "Treść komentarza może mieć maksymalnie 200 znaków.")]
        public string Content { get; set; }

        [DataType(DataType.DateTime)]
        [Display(Name = "Data dodania")]
        public DateTime Date { get; set; }

        [ScaffoldColumn(false)]
        [Display(Name = "Usluga")]
        public int ServiceId { get; set; }

        [ScaffoldColumn(false)]
        [Display(Name = "Usluga")]
        public string Service { get; set; }

        [ScaffoldColumn(false)]
        public int UserId { get; set; }

        [Display(Name = "Użytkownik")]
        public string User { get; set; }

        [Display(Name = "Adres IP")]
        public string IPAddress { get; set; }

        [Display(Name = "Kategoria")]
        public string CommentCategory { get; set; }

        [Display(Name = "Kategoria")]
        public int CommentCategoryId { get; set; }
    }

}
