﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MojeZdjeciaMvcWebRole.Models;
using System.Web.Security;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.StorageClient;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Net;
using System.Net.Mail;
using System.Security.Cryptography;
using System.Text;

namespace MojeZdjeciaMvcWebRole.Controllers
{
    public class ZdjeciaController : Controller
    {
        private ZdjecieDBContext db = new ZdjecieDBContext();

        [OutputCache(Duration = 600)]
        [HttpPost]
        public JsonResult PobierzKlucze(string SzukanaFraza)
        {
            // Przygotowanie kluczy w postaci obiektu Json, wybranie z bazy tytułu, nazwy i ID zdjęcia 
            // (po kliknięciu w rozwijanych podpowiedziach ID potrzebne jest do wyświetlenia szczegółów zdjęcia)
            var zdjecia = (from Zdjecie zdj in db.Zdjecia.Where(x => x.Tytul.Contains(SzukanaFraza) && !x.Sprzedane)
                           select new { Klucz = zdj.Tytul + " - " + zdj.NazwaUzytkownika, Wartosc = zdj.ID });
            return Json(zdjecia, JsonRequestBehavior.AllowGet);
        }

        public ActionResult Wyszukaj(String SzukanaFraza)
        {
            ViewBag.Title = "Wyszukiwanie zdjęć";

            // Pobranie wszystkich zdjęć.
            var zdjecia = db.Zdjecia.AsQueryable();

            //Jeśli łańcuch szukany niepusty to wybranie odpowiednich rekordów.
            if (!String.IsNullOrEmpty(SzukanaFraza))
            {
                zdjecia = db.Zdjecia.Where(x => x.Tytul.Contains(SzukanaFraza));
            }
            return View("Index", zdjecia);
        }

        private Boolean WyslijZdjecie(Zdjecie zdjecie, String Email)
        {
            try
            {
                // Przygotowanie tekstu wiadomości.
                MailMessage wiadomosc = new MailMessage()
                {
                    Subject = "Zdjęcie zakupione w serwisie Moje Zdjęcia",
                    Body = "Z załączniku znajduje się zakupione zdjęcie. Z poważaniem, Drużyna Moje Zdjęcia"
                };
                wiadomosc.To.Add(Email);

                // Pobranie zdjęcia z Blobs do strumienia.
                CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("AzureBlobsConnectionString"));
                CloudBlobClient cbc = csa.CreateCloudBlobClient();
                CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("zdjecia");
                CloudBlob blob = zdjeciaContainer.GetBlobReference(zdjecie.Link);

                // Pobranie atrybutów bloba (dla odczytania rozszerzenia pliku).
                blob.FetchAttributes();
                MemoryStream strumien = new MemoryStream();
                blob.DownloadToStream(strumien);

                // Ustawienie znacznika strumienia na początek.
                strumien.Position = 0;

                // Utworzenie załącznika wiadomości ze strumienia.
                Attachment zalacznik = new Attachment(strumien, blob.Name + blob.Properties.ContentType);

                // Dodanie załącznika do wiadomości.
                wiadomosc.Attachments.Add(zalacznik);

                // Przygotowanie klienta SMTP dla wysyłki wiadomości.
                SmtpClient smtp = new SmtpClient();

                // Ostateczne wysłanie wiadomości.
                smtp.Send(wiadomosc);

            }
            catch (Exception)
            {
                return false;
            }
            return true;
        }

        public ActionResult PrzyjmijPotwierdzenie(int id, String tokenKontrolny, String email)
        {
            // Znalezienie w bazie zdjęcia.
            Zdjecie zdjecie = db.Zdjecia.Find(id);

            // Jeśli zdjęcie nie istnieje to zwróć błąd.
            if (zdjecie == null)
                return HttpNotFound();

            // Wyliczenie tokena kontrolnego.
            String token = WyliczMD5("$@#asdad2" + zdjecie.Tytul + "$#%34sdsdf" +
              zdjecie.NazwaUzytkownika + "asDASD23" + zdjecie.ID +
              "E2asdas>.;,p" + zdjecie.Link + "#23as" + email + "2e312asd2");

            // Sprawdzenie czy token jest poprawny.
            if (!token.Equals(tokenKontrolny))
                return HttpNotFound();
            WyslijZdjecie(zdjecie, email);

            // Oznaczenie zdjęcia jako sprzedanego.
            zdjecie.Sprzedane = true;
            db.SaveChanges();

            return View("SprzedazZakonczona", new KupZdjecieViewModel() { Zdjecie = zdjecie, Email = email });
        }

        private Boolean WyslijPotwierdzenie(Zdjecie zdjecie, String Email)
        {
            try
            {
                // Wyliczenie tokena kontrolnego.
                String token = WyliczMD5("$@#asdad2" + zdjecie.Tytul + "$#%34sdsdf" +
                                        zdjecie.NazwaUzytkownika + "asDASD23" + zdjecie.ID +
                                        "E2asdas>.;,p" + zdjecie.Link + "#23as" + Email + "2e312asd2");

                // Przygotowanie tekstu wiadomości.
                MailMessage wiadomosc = new MailMessage()
                {
                    Subject = "Potwierdzenie zakupu zdjęcia w serwisie Moje-Zdjęcia",
                    Body = "<!DOCTYPE html><html lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta charset=\"utf-8\" />" +
                    "<title>Potwierdzenie zakupu zdjęcia w serwisie Moje-Zdjęcia</title></head><body>Kliknij link znajdujący się poniżej " +
                    "w celu potwierdzenie kupna zdjęcia.<br /><a href=\"" +
                    Url.Action("PrzyjmijPotwierdzenie", "Zdjecia", new { id = zdjecie.ID, tokenKontrolny = token, email = Email }, "http") + "\">Potwierdź</a></body></html>",
                    IsBodyHtml = true
                };
                wiadomosc.To.Add(Email);
                SmtpClient smtp = new SmtpClient();

                // Wysłanie wiadomości.
                smtp.Send(wiadomosc);

            }
            catch (Exception)
            {
                return false;
            }
            return true;
        }

        private String WyliczMD5(String wejscie)
        {
            // Krok 1: wyliczenie MD5 dla wejścia.
            MD5 md5 = System.Security.Cryptography.MD5.Create();
            byte[] bajtyWejsciowe = System.Text.Encoding.ASCII.GetBytes(wejscie);
            byte[] hash = md5.ComputeHash(bajtyWejsciowe);

            // Krok 2: przekonwertowanie tablicy bajtów na string.
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < hash.Length; i++)
            {
                sb.Append(hash[i].ToString("x2"));
            }
            return sb.ToString();
        }

        [Authorize]
        public ActionResult KupZdjecie(int id = 0)
        {
            // Znalezienie zdjęcia do wyświetlenia szczegółów. 
            Zdjecie zdjecie = db.Zdjecia.Find(id);

            // Jeśli zdjęcie nie istnieje to zwróć błąd.
            if (zdjecie == null || zdjecie.Sprzedane)
                return HttpNotFound();

            // Zwrócenie widoku potwierdzającego sprzedaż i pobierającego email użytkownika.
            return View(new KupZdjecieViewModel() { Zdjecie = zdjecie });
        }
        [Authorize]
        [HttpPost]
        public ActionResult KupZdjecie(KupZdjecieViewModel model)
        {
            // Znalezienie zdjęcia do wyświetlenia szczegółów
            Zdjecie pom = db.Zdjecia.Find(model.Zdjecie.ID);

            // Jeśli zdjęcie nie istnieje to zwróć błąd.
            if (pom == null)
                return HttpNotFound();
            model.Zdjecie.Tytul = pom.Tytul;

            // Wysłanie e-maila z potwierdzeniem zakupu.
            WyslijPotwierdzenie(pom, model.Email);

            // Zwrócenie widoku z informacją o wysłaniu zdjęcia.
            return View("PotwierdzenieWyslane", model);
        }

        public ActionResult PobierzZdjecie(int id = 0)
        {
            // Wynik akcji jest plikiem (dzięki temu można użyć URL akcji jako źródła obrazka).
            FileContentResult img = null;

            // Pobranie aktualnie zalogowane użytkownika.
            MembershipUser user = Membership.GetUser();

            // Pobranie zdjęcia.
            Zdjecie zdjecie = db.Zdjecia.Find(id);

            // Jeśli nie istnieje zwróć błąd.
            if (zdjecie == null)
                return null;

            // Pobranie zdjęcia z Blobs do strumienia.
            CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("AzureBlobsConnectionString"));
            CloudBlobClient cbc = csa.CreateCloudBlobClient();
            CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("zdjecia");
            CloudBlob blob = zdjeciaContainer.GetBlobReference(zdjecie.Link);
            MemoryStream bufor = new MemoryStream();
            blob.DownloadToStream(bufor);
            bufor.Position = 0;

            // Jeśli użytkownik jest niezarejestrowany lub nie jest właścicielem zdjęcia nałóż znak wodny.
            if (user == null || !zdjecie.IdUzytkownika.Equals(user.ProviderUserKey))
            {
                // Utworzenie obiektu Image ze strumienia, do którego pobrany został obrazek z Blobs.
                Image objImage = Image.FromStream(bufor);
                int height = objImage.Height;
                int width = objImage.Width;

                // Nałożenie tekstowego znaku wodnego.
                System.Drawing.Bitmap bitmapimage = new System.Drawing.Bitmap(objImage, width, height);
                System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(bitmapimage);
                SolidBrush brush = new SolidBrush(Color.FromArgb(113, 255, 255, 255));
                g.RotateTransform(45f);
                g.DrawString("Znak wodny - portal Moje Zdjęcia", new Font("Arial", height / 20, System.Drawing.FontStyle.Bold), brush, height / 20 + 35, -15);
                g.RotateTransform(-45f);

                // Zapisanie obrazka.
                bufor = new MemoryStream();
                bitmapimage.Save(bufor, ImageFormat.Jpeg);
            }

            // Podstawienie pod wynik pliku ze strumienia.
            img = this.File(bufor.GetBuffer(), "image/jpeg");
            return img;
        }

        [Authorize]
        public ActionResult MojeZdjecia()
        {
            // Pobranie Id aktualnie zalogowanego użytkownika.
            Int32 user = (Int32)Membership.GetUser().ProviderUserKey;
            ViewBag.Title = "Moje zdjęcia";

            // Przekazanie do widoku zmiennej mówiącej o tym, że źródłem jest akcja MojeZdjecia
            // w celu zablokowania niektórych funkcji niedostępnych dla użytkownika niezarejestrowanego.
            ViewBag.MojeZdjecia = true;

            // Wybranie zdjęć tylko zalogowanego użytkownika.
            var zdjecia = db.Zdjecia.Where(x => x.IdUzytkownika.Equals(user));
            return View("Index", zdjecia);
        }


        //
        // GET: /Zdjecia/

        public ActionResult Index()
        {
            return View(db.Zdjecia.ToList());
        }

        //
        // GET: /Zdjecia/Details/5

        public ActionResult Details(int id = 0)
        {
            Zdjecie zdjecie = db.Zdjecia.Find(id);
            if (zdjecie == null)
            {
                return HttpNotFound();
            }
            return View(zdjecie);
        }

        [Authorize]
        public ActionResult Create()
        {
            return View();
        }

        [Authorize]
        [HttpPost]
        public ActionResult Create(Zdjecie zdjecie, HttpPostedFileBase Link)
        {
            // Sprawdzenie czy dane z formularze są poprawne oraz plik obrazka wybrany.
            if (ModelState.IsValid && Link != null)
            {
                // Przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym.
                CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("AzureBlobsConnectionString"));
                CloudBlobClient cbc = csa.CreateCloudBlobClient();

                // Wybranie kontenera blobów.
                CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("zdjecia");
                zdjeciaContainer.CreateIfNotExist();

                // Przygotowanie nowego bloba.
                CloudBlob cb = zdjeciaContainer.GetBlobReference(Guid.NewGuid().ToString());
                cb.Properties.ContentType = Path.GetExtension(Link.FileName);

                // Wysłanie bloba do Azure Storage.
                cb.UploadFromStream(Link.InputStream);

                // Pobranie odsyłacza do obrazka w Azure Blobs.
                zdjecie.Link = cb.Uri.ToString();

                // Wprowadzenie Id użytkownika.
                zdjecie.IdUzytkownika = (Int32)Membership.GetUser().ProviderUserKey;

                // Skopiowanie nazwy użytkownika do zdjęcia.
                zdjecie.NazwaUzytkownika = Membership.GetUser().UserName;

                // Dodanie zdjęcia do bazy.
                db.Zdjecia.Add(zdjecie);
                db.SaveChanges();

                // Przekierowanie do listy zdjęć użytkownika.
                return RedirectToAction("MojeZdjecia");
            }
            return View(zdjecie);
        }


        [Authorize]
        public ActionResult Edit(int id = 0)
        {
            // Znalezienie zdjęcia do edycji.
            Zdjecie zdjecie = db.Zdjecia.Find(id);

            // Jeśli nie istnieje zwróć błąd.
            if (zdjecie == null)
                return HttpNotFound();

            // Jeśli użytkownik nie jest właścicielem zdjęcia to jest przekierowywany na stronę startową.
            if (!zdjecie.IdUzytkownika.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");
            return View(zdjecie);
        }

        [Authorize]
        [HttpPost]
        public ActionResult Edit(Zdjecie zdjecie, string staryLink, HttpPostedFileBase Link)
        {
            // Pobranie zdjęcia.
            Zdjecie zdjecieLocal = db.Zdjecia.Find(zdjecie.ID);

            // Jeśli użytkownik nie jest właścicielem zdjęcia to jest przekierowywany na stronę startową 
            if (!zdjecieLocal.IdUzytkownika.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");

            // Sprawdzenie czy dane z formularze poprawne.
            if (ModelState.IsValid)
            {
                // Jeżeli zmieniono plik obrazka to zapisanie nowego do Azure Blobs
                if (Link != null)
                {
                    // Przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym
                    CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("AzureBlobsConnectionString"));
                    CloudBlobClient cbc = csa.CreateCloudBlobClient();
                    CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("zdjecia");
                    zdjeciaContainer.CreateIfNotExist();
                    // Przygotowanie bloba.
                    CloudBlob cb = zdjeciaContainer.GetBlobReference(Guid.NewGuid().ToString());
                    cb.Properties.ContentType = Path.GetExtension(Link.FileName);
                    cb.UploadFromStream(Link.InputStream);

                    // Pobranie odsyłacza zmienionego obrazka.
                    zdjecie.Link = cb.Uri.ToString();

                    // Znalezienie starego bloba do usunięcia.
                    CloudBlob oldBlob = zdjeciaContainer.GetBlobReference(staryLink);

                    // Usuwanie starego bloba.
                    oldBlob.Delete();

                }
                // Jeżeli nie zmieniono to zapisanie poprzedniego odsyłacza.
                else
                {
                    zdjecie.Link = staryLink;
                }

                // Wprowadzenie Id i nazwy użytkownika.
                zdjecie.IdUzytkownika = zdjecieLocal.IdUzytkownika;
                zdjecie.NazwaUzytkownika = zdjecieLocal.NazwaUzytkownika;

                //Oznaczenie rekordu jako zmodyfikowanego, ważne dla EF.
                db.Entry(zdjecieLocal).CurrentValues.SetValues(zdjecie);

                // Dodanie zdjęcia do bazy.
                db.SaveChanges();

                // Przekierowanie do listy zdjęć użytkownika.
                return RedirectToAction("MojeZdjecia");
            }

            return View(zdjecie);
        }


        [Authorize]
        public ActionResult Delete(int id = 0)
        {
            // Znalezienie zdjęcia do usunięcia.
            Zdjecie zdjecie = db.Zdjecia.Find(id);

            // Jeśli nie istnieje zwróć błąd.
            if (zdjecie == null)
                return HttpNotFound();

            // Jeśli użytkownik nie jest właścicielem zdjęcia to jest przekierowywany na stronę startową.
            if (!zdjecie.IdUzytkownika.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");
            return View(zdjecie);
        }

        [Authorize]
        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Zdjecie zdjecie = db.Zdjecia.Find(id);
            // Jeśli użytkownik nie jest właścicielem zdjęcia to jest przekierowywany na stronę startową.
            if (!zdjecie.IdUzytkownika.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");

            // Przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym.
            CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("AzureBlobsConnectionString"));
            CloudBlobClient cbc = csa.CreateCloudBlobClient();

            // Znalezienie bloba.
            CloudBlob cb = cbc.GetBlobReference(zdjecie.Link);

            // Usuwanie bloba.
            cb.Delete();

            // Usunięcie zdjęcia z bazy.
            db.Zdjecia.Remove(zdjecie);
            db.SaveChanges();

            // Przekierowanie do listy zdjęć użytkownika.
            return RedirectToAction("MojeZdjecia");
        }


        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}