﻿using System;
using System.ComponentModel.DataAnnotations;

namespace SerwisSubskrypcja.Models
{
    public class Subscriber
    {
        [ScaffoldColumn(false)]
        public long Id { get; set; }

        [StringLength(50, ErrorMessage = "Imię może mieć maksymalnie 50 znaków")]
        [Required(ErrorMessage = "Imię jest wymagane.")]
        [Display(Name = "Imię")]
        public string Name { get; set; }

        [Required(ErrorMessage = "Nazwisko jest wymagane.")]
        [StringLength(50, ErrorMessage = "Nazwisko może mieć maksymalnie 50 znaków.")]
        [Display(Name = "Nazwisko")]
        public string Surname { get; set; }

        [StringLength(100, ErrorMessage = "Adres e-mail może mieć maksymalnie 100 znaków.")]
        [Required(ErrorMessage = "Adres e-mail jest wymagany.")]
        [Display(Name = "Adres e-mail")]
        [RegularExpression(@"^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$", ErrorMessage = "Adres e-mail jest niepoprawny.")]
        public string Email { get; set; }

        [Display(Name = "Data rejestracji")]
        [DataType(DataType.DateTime)]
        public DateTime RegistrationDate { get; set; }
    }

}
