﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Data.Entity;

namespace MojeZdjeciaMvcWebRole.Models
{
    public class ZdjecieDBContext : DbContext
    {
        public DbSet<Zdjecie> Zdjecia { get; set; }
    }

    public class Zdjecie
    {
        //unikatowy identyfikator zdjęcia
        [Key]
        public int ID { get; set; }

        //ID użytkownika, który dodał zdjęcie
        public Int32 IdUzytkownika { get; set; }

        //Nazwa użytkownika ustawiana przy dodawania zdjęcia
        [DataType(DataType.Text)]
        [Display(Name = "Nazwa użytkownika")]
        public string NazwaUzytkownika { get; set; }

        //tytuł zdjęcia
        [DataType(DataType.Text)]
        [Required(ErrorMessage = "Pole Tytuł nie może być puste!")]
        [Display(Name = "Tytuł")]
        public string Tytul { get; set; }

        //data publikacja zdjęcie
        [Column(TypeName = "datetime2")]
        [DataType(DataType.Date, ErrorMessage = "Zły format daty!")]
        [Required(ErrorMessage = "Pole Data Publikacji nie może być puste!")]
        [Display(Name = "Data publikacji")]
        public DateTime DataPublikacji { get; set; }

        //kategoria zdjęcia
        [Required(ErrorMessage = "Pole Kategoria nie może być puste!")]
        [StringLength(25, MinimumLength = 3, ErrorMessage = "Nazwa kategorii musi składać się z minimum 3 i maksimum 25 znaków")]
        public string Kategoria { get; set; }

        //cena zdjęcia
        [DataType(DataType.Currency, ErrorMessage = "Zły format ceny!")]
        [Required(ErrorMessage = "Pole Cena nie może być puste!")]
        [Range(0.0, 1000.00, ErrorMessage = "Cena musi być w zakresie od 0 do 1000 zł")]
        [DisplayFormat(DataFormatString = "{0:C}", ApplyFormatInEditMode = true)]
        public decimal Cena { get; set; }

        //znacznik sprzedaży zdjęcia
        public Boolean Sprzedane { get; set; }

        //odsyłacz do zdjęcia przechowywanego w Azure Blobs
        [Display(Name = "Obrazek")]
        public string Link { get; set; }
    }

}