﻿using SerwisSubskrypcja.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace SerwisSubskrypcja.Controllers
{
    public class SubscriberController : Controller
    {
        private SubscriptionContext _db = new SubscriptionContext();

        public SubscriberController()
        {
            _db = new SubscriptionContext();
        }

        public ActionResult Index()
        {
            ViewBag.Message = "Witaj w serwisie Subskrypcja!";
            return View();
        }

        [Authorize(Roles = "Administrator")]
        public ActionResult List()
        {
            // Pobranie listy subskrybentów i wyświetlenie ich w widoku
            var subscribers = _db.Subscribers;
            return View(subscribers);
        }

        public ActionResult Subscribe()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Subscribe(Subscriber model)
        {
            // Sprawdzenie, czy model jest poprawny
            if (ModelState.IsValid)
            {
                try
                {
                    // Pobranie subskrybenta o podanym w modelu adresie e-mail w celu sprawdzenia, 
                    // czy na ten adres e-mail została już zarejestrowana subskrypcja
                    var subscriber = _db.Subscribers.FirstOrDefault(u => u.Email.Equals(model.Email));

                    if (subscriber == null) // Jeżeli nie znaleziono subskrybenta, to można go zarejestrować.
                    {
                        subscriber = model;
                        subscriber.RegistrationDate = DateTime.Now;

                        _db.Subscribers.Add(subscriber);
                        _db.SaveChanges();  // Dodanie subskrybenta do bazy danych i zapisanie zmian                    
                    }
                    else
                    {
                        // Jeżeli subskrybent o podanym adresie e-mail został znaleziony, to wyświetlany jest błąd.
                        TempData["Error"] = "Taki adres e-mail jest już zarejestrowany.";
                        return View(model);
                    }
                }
                catch
                {
                    TempData["Error"] = "Coś poszło nie tak!";
                    return View();
                }

                // Jeżeli wszystko zostało wykonane poprawnie, użytkownik zostanie 
                // przeniesiony na stronę główną z komunikatem.
                TempData["Message"] = "Adres e-mail został zapisany.";
                return RedirectToAction("Index");

            }
            else
            {
                // Jeżeli model nie jest poprawnie wypełniony, użytkownik pozostanie na stronie wprowadzania danych.
                return View(model);
            }
        }

        public ActionResult Unsubscribe()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Unsubscribe(Subscriber model)
        {
            // Sprawdzenie, czy model jest poprawny
            if (ModelState.IsValid)
            {
                try
                {
                    // Pobranie subskrybenta o podanym w modelu adresie e-mail, imieniu i nazwisku
                    var subscriber = _db.Subscribers.FirstOrDefault(u => (u.Email.Equals(model.Email) && u.Name.Equals(model.Name) && u.Surname.Equals(model.Surname)));

                    if (subscriber != null)
                    {
                        // Jeżeli subskrybent zostanie znaleziony, to jest usuwany, a zmiany są zapisywane.
                        _db.Subscribers.Remove(subscriber);
                        _db.SaveChanges();
                    }
                    else
                    {
                        // Jeżeli subskrybent nie zostanie odnaleziony, to użytkownik pozostanie na stronie wprowadzania danych.
                        TempData["Error"] = "Subskrypcja o takich danych nie istnieje. Popraw dane i spróbuj jeszcze raz.";
                        return View(model);
                    }
                }
                catch
                {
                    TempData["Error"] = "Coś poszło nie tak!";
                    return View();
                }

                // Jeżeli wszystko zostało wykonane poprawnie, użytkownik zostanie 
                // przeniesiony na stronę główną z komunikatem.     
                TempData["Message"] = "Pomyślnie usunięto adres e-mail!";
                return RedirectToAction("Index");
            }
            else
            {
                return View(model);
            }
        }
    }
}
