using System;
using System.IO;
using System.Xml;
using System.Xml.Linq;
using System.Xml.XPath;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // Wczytaj dokument
        string booksFile = Server.MapPath("books.xml");
        XDocument document = XDocument.Load(booksFile);

        // Dodaj prefiks przestrzeni nazw, aby mg by wykorzystany w wyraeniu XPath.   
        // Warto zwrci uwag na obiekt NameTable. Moe on by nowy lub pochodzi z dowolnego rda.		
        XmlNamespaceManager namespaceMgr = new XmlNamespaceManager(new NameTable());
        namespaceMgr.AddNamespace("b", "http://example.books.com");

        var nodes = document.XPathSelectElements("//b:book[not(b:price[. > 10.00])]/b:price",namespaceMgr);

        // Wszystkie ksiki, ktrych cena nie jest wiksza ni 10.00
        foreach (var node in nodes)
        {
            Response.Write(node.Value + "<BR/>");
        }
    }
}
