﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Text
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls

Namespace ServerControl.VB
    <DefaultProperty("Text"),
    ToolboxData("<{0}:ServerControl27 runat=server></{0}:ServerControl27>")>
    Public Class ServerControl27
        Inherits WebControl
        Implements ICallbackEventHandler

        <Bindable(True), Category("Appearance"), DefaultValue(""), Localizable(True)>
        Property Text() As String
            Get
                Dim s As String = CStr(ViewState("Text"))
                If s Is Nothing Then
                    Return "[" + Me.ID + "]"
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("Text") = Value
            End Set
        End Property

        Protected Overrides Sub RenderContents(ByVal output As HtmlTextWriter)
            output.RenderBeginTag(HtmlTextWriterTag.Div)

            output.AddAttribute(HtmlTextWriterAttribute.Type, "text")
            output.AddAttribute(HtmlTextWriterAttribute.Id, Me.ClientID & "_i")
            output.AddAttribute(HtmlTextWriterAttribute.Name, Me.ClientID & "_i")
            output.AddAttribute(HtmlTextWriterAttribute.Value, Me.Text)

            output.AddAttribute("OnBlur", "ClientCallback();")

            output.RenderBeginTag(HtmlTextWriterTag.Input)
            output.RenderEndTag()

            output.RenderEndTag()

        End Sub

        Protected Overrides Sub OnPreRender(ByVal e As System.EventArgs)
            If (Page.Request.Browser.EcmaScriptVersion.Major > 0) Then

                Page.ClientScript.RegisterClientScriptInclude(
                    "UtilityFunctions", "Listing25-25.js")

                Page.ClientScript.RegisterStartupScript(
                    GetType(Page), "ClientCallback",
                    "function ClientCallback() {" &
                        "args=document.getElementById('" & Me.ClientID & "_i" & "').value;" &
                        Page.ClientScript.GetCallbackEventReference(Me, "args",
                           "CallbackHandler", Nothing, "ErrorHandler", True) + "}",
                    True)

                Page.ClientScript.RegisterStartupScript(GetType(Page),
                    "ControlFocus", "document.getElementById('" &
                    Me.ClientID & "_i" & "').focus();",
                    True)
            End If
        End Sub


        Public Sub RaiseCallbackEvent(ByVal eventArgument As String) _
            Implements System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent

            Dim result As Int32
            If (Not Int32.TryParse(eventArgument, result)) Then
                Throw New Exception("Metoda lub operacja nie jest zaimplementowana.")
            End If
        End Sub

        Public Function GetCallbackResult() As String _
            Implements System.Web.UI.ICallbackEventHandler.GetCallbackResult

            Return "Dane poprawne"
        End Function

    End Class
End Namespace