﻿Imports System 
Imports System.Web.Services 

' Aby umożliwić wywołanie usługi sieciowej ze skryptu 
' używając ASP.NET AJAX, trzeba usunąć komentarz z początku poniższego wiersza. 
' [System.Web.Script.Services.ScriptService] 
<WebService([Namespace] := "http://tempuri.org/")> _ 
<WebServiceBinding(ConformsTo := WsiProfiles.BasicProfile1_1)> _ 
Public Class StockTickerSimple 
    Inherits WebService 
    ' Konstruujemy i wypełniamy tablicę symboli giełdowych oraz ich cen.
    ' Uwaga: ceny dotyczą giełdy w USA z  dnia 30/7/2008.
    Private stocks As String(,) = {{"MSFT", "Microsoft", "26.23"}, {"DELL", "Dell Inc", "24.00"}, {"HPQ", "Hewlett-Packard", "45.06"}, {"GOOG", "Google", "482.70"}, {"YHOO", "Yahoo!", "20.03"}, {"GE", "General Electric", "28.97"}, _ 
    {"IBM", "International Business Machines", "128.86"}, {"GM", "General Motors", "11.40"}, {"F", "Ford Motor Company", "4.84"}} 
    
    <WebMethod()> _ 
    Public Function GetPrice(ByVal StockSymbol As String) As Double 
        ' Podajemy symbol giełdowy, otrzymujemy cenę waloru. 
        ' Przeglądamy kolejno elementy tablicy w poszukiwaniu symbolu. 
        For i As Integer = 0 To stocks.GetLength(0) - 1 
            ' Przeprowadzamy porównanie ciągów tekstowych bez rozróżniania małych i dużych liter.
            If [String].Compare(StockSymbol, stocks(i, 0), True) = 0 Then 
                Return Convert.ToDouble(stocks(i, 2)) 
            End If 
        Next 
        Return 0 
    End Function 
    
    <WebMethod()> _ 
    Public Function GetName(ByVal StockSymbol As String) As String 
        ' Podajemy symbol giełdowy, otrzymujemy cenę waloru.
        ' Przeglądamy kolejno elementy tablicy w poszukiwaniu symbolu.
        For i As Integer = 0 To stocks.GetLength(0) - 1 
            ' Przeprowadzamy porównanie ciągów tekstowych bez rozróżniania małych i dużych liter. 
            If [String].Compare(StockSymbol, stocks(i, 0), True) = 0 Then 
                Return stocks(i, 1) 
            End If 
        Next 
        Return "Symbol nie został znaleziony." 
    End Function 
End Class 