﻿using System;
using System.Data;
using System.IO;
using System.Web.Caching;
using System.Web.UI;
using System.Xml;

public partial class ObjectCachingCallback : Page
{
   public static CacheItemRemovedCallback onRemove = null;

   protected void Page_Load(object sender, EventArgs e)
   {
      CreateGridView();
   }

   private void CreateGridView()
   {
      DataSet dsGrid;
      dsGrid = (DataSet)Cache["GridViewDataSet"];

      onRemove = new CacheItemRemovedCallback(this.RemovedCallback);

      if (dsGrid == null)
      {
         dsGrid = GetDataSet();
         string[] fileDependsArray = { Server.MapPath("Customers.xml") };
         string[] cacheDependsArray = { "Depend0", "Depend1", "Depend2" };
         CacheDependency cacheDepends = new CacheDependency
            (fileDependsArray, cacheDependsArray);
         Cache.Insert("GridViewDataSet", dsGrid, cacheDepends,
            DateTime.Now.AddSeconds(10), Cache.NoSlidingExpiration, 
            CacheItemPriority.Default, 
            onRemove);
         lblMessage.Text = "Dane z pliku XML.";
      }
      else
      {
         lblMessage.Text = "Dane z bufora.";
      }

      gvwCustomers.DataSource = dsGrid.Tables[0];
      gvwCustomers.DataBind();
   }

   private DataSet GetDataSet()
   {
      DataSet dsData = new DataSet();
      XmlDataDocument doc = new XmlDataDocument();
      doc.DataSet.ReadXml(Server.MapPath("Customers.xml"));
      dsData = doc.DataSet;
      return dsData;
   }

   public void RemovedCallback(string cacheKey, Object cacheObject, CacheItemRemovedReason reasonToRemove)    
   {       
      WriteFile("Bufor usunięty z następującego powodu: " +          
         reasonToRemove.ToString());    
   }     
   
   private void WriteFile(string strText)    
   {       
      StreamWriter writer = new StreamWriter("~\test.txt", true);       
      writer.WriteLine(String.Format("{0} {1}",
         DateTime.Now.ToString(), strText));       
      writer.Close();    
   }

   protected void btnClear_Click(object sender, EventArgs e)
   {
      Cache.Remove("GridViewDataSet");
      CreateGridView();
   }

   protected void btnInit_Click(object sender, EventArgs e)
   {
      //  Inicjalizacja buforów uzależniających.             
      Cache["Depend0"] = "To jest pierwsza zależność.";
      Cache["Depend1"] = "To jest druga zależność.";
      Cache["Depend2"] = "To jest trzecia zależność.";
   }

   protected void btnChange_Click(object sender, EventArgs e)
   {
      Cache["Depend0"] = "To jest zmieniona pierwsza zależność.";
   }
}
