﻿using System;
using System.Web.Services;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// Aby umożliwić wywołanie usługi sieciowej ze skryptu 
// używając ASP.NET AJAX, trzeba usunąć komentarz z początku poniższego wiersza.  
// [System.Web.Script.Services.ScriptService]
public class StockTickerSimple : WebService
{
    //  Konstruujemy i wypełniamy tablicę symboli giełdowych oraz ich cen.
    // Uwaga: ceny dotyczą giełdy w USA z  dnia 30/7/2008.
    string[,] stocks =
      {
         {"MSFT","Microsoft","26.23"},
         {"DELL","Dell Inc","24.00"},
         {"HPQ","Hewlett-Packard","45.06"},         
		 {"GOOG","Google","482.70"},
         {"YHOO","Yahoo!","20.03"},
         {"GE","General Electric","28.97"},
         {"IBM","International Business Machines","128.86"},
         {"GM","General Motors","11.40"},
         {"F","Ford Motor Company","4.84"}
      };

    [WebMethod]
    public double GetPrice(string StockSymbol)
        //  Podajemy symbol giełdowy, otrzymujemy cenę waloru.
    {
        //  Przeglądamy kolejno elementy tablicy w poszukiwaniu symbolu.
        for (int i = 0; i < stocks.GetLength(0); i++) {
            //  Przeprowadzamy porównanie ciągów tekstowych bez rozróżniania małych i dużych liter.
            if (String.Compare(StockSymbol, stocks[i, 0], true) == 0)
                return Convert.ToDouble(stocks[i, 2]);
        }
        return 0;
    }

    [WebMethod]
    public string GetName(string StockSymbol)
        //  Podajemy symbol giełdowy, otrzymujemy cenę waloru.
    {
        //  Przeglądamy kolejno elementy tablicy w poszukiwaniu symbolu.
        for (int i = 0; i < stocks.GetLength(0); i++) {
            //  Przeprowadzamy porównanie ciągów tekstowych bez rozróżniania małych i dużych liter.
            if (String.Compare(StockSymbol, stocks[i, 0], true) == 0)
                return stocks[i, 1];
        }
        return "Symbol nie został znaleziony.";
    }
}
