﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;

namespace CustomControls
{
    [ToolboxData("<{0}:BookInquiryList runat=server></{0}:BookInquiryList>")]
    [ControlBuilderAttribute(typeof(BookCounterBuilder)), ParseChildren(false)]
    public class BookInquiryList : WebControl, INamingContainer
    {
        protected override void Render(HtmlTextWriter output)
        {
            int totalInquiries = 0;
            BookCounter current;


            // Tworzenie nagłówka.
            output.Write("<Table border='1' width='90%' cellpadding='1'" +
               "cellspacing='1' align = 'center' >");
            output.Write("<tr><td colspan = '2' align='center'>");
            output.Write("<b> Zapytania </b></td></tr>");

            // Jeżeli nie ma zawierających kontrolek, wtedy wyświetlamy domyślny komunikat.
            if (Controls.Count == 0)
            {
                output.Write("<tr><td colspan='2' align='center'>");
                output.Write("<b> Brak książek. </b></td></tr>");
            }
            // W przeciwnym przypadku generujemy każdą z zawartych kontrolek.
            else
            {
                // Przechodzimy kolejno przez zbiór kontrolek
                // i wyświetlamy dla każdej z nich tytuł książki.
                // Następnie generujemy każdą zawartą kontrolkę.
                for (int i = 0; i < Controls.Count; i++)
                {
                    current = Controls[i] as BookCounter;

                    if (current != null)
                    {
                        totalInquiries += current.Count;
                        output.Write("<tr><td align='left'>" +
                           current.BookName + "</td>");
                        output.RenderBeginTag("td");
                        current.RenderControl(output);
                        output.RenderEndTag();  // Koniec znacznika td.
                        output.Write("</tr>");
                    }
                }
                output.Write("<tr><td colspan='2' align='center'> " +
                   " Całkowita liczba zapytań: " +
                   totalInquiries + "</td></tr>");
            }
            output.Write("</table>");
        }
    }




    internal class BookCounterBuilder : ControlBuilder
    {
        public override Type GetChildControlType(
           string tagName, IDictionary attributes)
        {
            if (tagName == "BookCounter")
                return typeof(BookCounter);
            else
                return null;
        }

        public override void AppendLiteralString(string s)
        {
        }
    }

}
