﻿<%@ Control Language="VB" AutoEventWireup="true" CodeFile="CustomerDataList.ascx.vb"
   Inherits="CustomerDataList" %>
<div>
   <asp:SqlDataSource ID="dsCustomers" runat="server" 
      ConnectionString="<%$ ConnectionStrings:AWLTConnection %>"
      DeleteCommand="DELETE FROM [SalesLT].[Customer] WHERE [CustomerID] = @CustomerID"
      SelectCommand="
            SELECT TOP 9 [CustomerID], [NameStyle],
	            CASE WHEN [Title] IS NULL THEN '' ELSE [Title] + ' ' END +
               [FirstName] + ' ' +
	            CASE WHEN [MiddleName] IS NULL THEN '' ELSE [MiddleName] + ' ' END +
	            [LastName] + 
	            CASE WHEN [Suffix] IS NULL THEN '' ELSE ' ' + [Suffix] END as 'FullName',
	            [Title], [FirstName], [MiddleName], [LastName], [Suffix],
	            [CompanyName], [SalesPerson], [ModifiedDate], [EmailAddress], [Phone], 
	            [PasswordHash], [PasswordSalt]
               FROM [SalesLT].[Customer]" UpdateCommand="
            UPDATE [SalesLT].[Customer] SET 
               [NameStyle] = @NameStyle, [Title] = @Title, [FirstName] = @FirstName, 
               [MiddleName] = @MiddleName, [LastName] = @LastName, [Suffix] = @Suffix, 
               [CompanyName] = @CompanyName, [SalesPerson] = @SalesPerson, 
               [EmailAddress] = @EmailAddress, [Phone] = @Phone, 
               [ModifiedDate] = GetDate() WHERE [CustomerID] = @CustomerID">
      <DeleteParameters>
         <asp:Parameter Name="CustomerID" Type="Int32" />
      </DeleteParameters>
      <UpdateParameters>
         <asp:Parameter Name="NameStyle" Type="Boolean" />
         <asp:Parameter Name="Title" Type="String" />
         <asp:Parameter Name="FirstName" Type="String" />
         <asp:Parameter Name="MiddleName" Type="String" />
         <asp:Parameter Name="LastName" Type="String" />
         <asp:Parameter Name="Suffix" Type="String" />
         <asp:Parameter Name="CompanyName" Type="String" />
         <asp:Parameter Name="SalesPerson" Type="String" />
         <asp:Parameter Name="EmailAddress" Type="String" />
         <asp:Parameter Name="Phone" Type="String" />
         <asp:Parameter Name="CustomerID" Type="Int32" />
      </UpdateParameters>
   </asp:SqlDataSource>
   <asp:DataList ID="DataList1" runat="server" DataKeyField="CustomerID" DataSourceID="dsCustomers"
      GridLines="Vertical" RepeatColumns="3" OnEditCommand="DataList1_EditCommand" OnCancelCommand="DataList1_CancelCommand"
      OnDeleteCommand="DataList1_DeleteCommand" OnUpdateCommand="DataList1_UpdateCommand"
      BackColor="White" BorderColor="#999999" BorderStyle="Solid" BorderWidth="1px"
      CellPadding="3" ForeColor="Black" OnSelectedIndexChanged="DataList1_SelectedIndexChanged">
      <ItemTemplate>
         Imię i nazwisko:
         <asp:Label ID="FullNameLabel" runat="server" Text='<%# Eval("FullName") %>' />
         <br />
         Nazwa firma:
         <asp:Label ID="CompanyNameLabel" runat="server" Text='<%# Eval("CompanyName") %>' />
         <br />
         Przedstawiciel:
         <asp:Label ID="SalesPersonLabel" runat="server" Text='<%# Eval("SalesPerson") %>' />
         <br />
         Data ostatniej modyfikacji:
         <asp:Label ID="ModifiedDateLabel" runat="server" Text='<%# Eval("ModifiedDate", "{0:dd/MM/yyyy}") %>' />
         <br />
         Adres e-mail:
         <asp:HyperLink ID="hypEmailReadOnly" runat="server" NavigateUrl='<%# Eval("EmailAddress", "mailto:{0}") %>'
            Text='<%# Eval("EmailAddress") %>' />
         <br />
         Telefon:
         <asp:Label ID="PhoneLabel" runat="server" Text='<%# Eval("Phone") %>' />
         <br />
         Wartość hash:
         <asp:Label ID="PasswordHashLabel" runat="server" Text='<%# Eval("PasswordHash") %>' />
         <br />
         Wartość salt:
         <asp:Label ID="PasswordSaltLabel" runat="server" Text='<%# Eval("PasswordSalt") %>' />
         <br />
         <asp:Button runat="server" ID="btnSelect" Text="Zaznacz" CommandName="Select" />
         <asp:Button runat="server" ID="btnEdit" Text="Edytuj" CommandName="Edit" />
         <asp:Button runat="server" ID="btnDelete" Text="Usuń" CommandName="Delete" />
      </ItemTemplate>
      <FooterStyle BackColor="#CCCCCC" />
      <AlternatingItemStyle BackColor="#CCCCCC" />
      <EditItemTemplate>
         Nazwa stylu:
         <asp:CheckBox ID="NameStyleCheckBox" runat="server" Checked='<%# Bind("NameStyle") %>' />
         <br />
         Tytuł:
         <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' />
         <br />
         Imię:
         <asp:TextBox ID="FirstNameTextBox" runat="server" Text='<%# Bind("FirstName") %>' />
         <br />
         Drugie imię:
         <asp:TextBox ID="MiddleNameTextBox" runat="server" Text='<%# Bind("MiddleName") %>' />
         <br />
         Nazwisko:
         <asp:TextBox ID="LastNameTextBox" runat="server" Text='<%# Bind("LastName") %>' />
         <br />
         Przyrostek:
         <asp:TextBox ID="SuffixTextBox" runat="server" Text='<%# Bind("Suffix") %>' />
         <br />
         Nazwa firmy:
         <asp:TextBox ID="CompanyNameTextBox" runat="server" Text='<%# Bind("CompanyName") %>' />
         <br />
         Przedstawiciel:
         <asp:TextBox ID="SalesPersonTextBox" runat="server" Text='<%# Bind("SalesPerson") %>' />
         <br />
         Adres e-mail:
         <asp:TextBox ID="EmailAddressTextBox" runat="server" Text='<%# Bind("EmailAddress") %>' />
         <br />
         Telefon:
         <asp:TextBox ID="PhoneTextBox" runat="server" Text='<%# Bind("Phone") %>' />
         <br />
         <asp:Button runat="server" ID="btnUpdate" Text="Aktualizuj" CommandName="Update" />
         <asp:Button runat="server" ID="btnCancel" Text="Anuluj" CommandName="Cancel" />
      </EditItemTemplate>
      <SelectedItemStyle BackColor="#000099" Font-Bold="True" ForeColor="White" />
      <HeaderStyle BackColor="Black" Font-Bold="True" ForeColor="White" />
      <SelectedItemTemplate>
         Imię i nazwisko:
         <asp:Label ID="FullNameLabel" runat="server" Text='<%# Eval("FullName") %>' />
         <br />
         Nazwa firmy:
         <asp:Label ID="CompanyNameLabel" runat="server" Text='<%# Eval("CompanyName") %>' />
         <br />
         Przedstawiciel:
         <asp:Label ID="SalesPersonLabel" runat="server" Text='<%# Eval("SalesPerson") %>' />
         <br />
         Data ostatniej modyfikacji:
         <asp:Label ID="ModifiedDateLabel" runat="server" Text='<%# Eval("ModifiedDate", "{0:dd/MM/yyyy}") %>' />
         <br />
         Adres e-mail:
         <asp:HyperLink ID="hypEmailReadOnly" runat="server" NavigateUrl='<%# Eval("EmailAddress", "mailto:{0}") %>'
            Text='<%# Eval("EmailAddress") %>' />
         <br />
         Telefon:
         <asp:Label ID="PhoneLabel" runat="server" Text='<%# Eval("Phone") %>' />
         <br />
         Wartość hash:
         <asp:Label ID="PasswordHashLabel" runat="server" Text='<%# Eval("PasswordHash") %>' />
         <br />
         Wartość salt:
         <asp:Label ID="PasswordSaltLabel" runat="server" Text='<%# Eval("PasswordSalt") %>' />
         <br />
         <asp:Button runat="server" ID="btnCancelSelect" Text="Odznacz" CommandName="Cancel" />
      </SelectedItemTemplate>
   </asp:DataList>
</div>
