﻿using System;
using System.Data;
using System.Web.Caching;
using System.Web.UI;
using System.Xml;

public partial class ObjectCachingItemDependency : Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      CreateGridView();
   }

   private void CreateGridView()
   {
      DataSet dsGrid;
      dsGrid = (DataSet)Cache["GridViewDataSet"];
      if (dsGrid == null)
      {
         dsGrid = GetDataSet();
         string[] fileDependsArray = { Server.MapPath("Customers.xml") };
         string[] cacheDependsArray = { "Depend0", "Depend1", "Depend2" };
         CacheDependency cacheDepends = new CacheDependency
            (fileDependsArray, cacheDependsArray);
         Cache.Insert("GridViewDataSet", dsGrid, cacheDepends);
         lblMessage.Text = "Dane z pliku XML.";
      }
      else
      {
         lblMessage.Text = "Dane z bufora.";
      }

      gvwCustomers.DataSource = dsGrid.Tables[0];
      gvwCustomers.DataBind();
   }

   private DataSet GetDataSet()
   {
      DataSet dsData = new DataSet();
      XmlDataDocument doc = new XmlDataDocument();
      doc.DataSet.ReadXml(Server.MapPath("Customers.xml"));
      dsData = doc.DataSet;
      return dsData;
   }


   protected void btnClear_Click(object sender, EventArgs e)
   {
      Cache.Remove("GridViewDataSet");
      CreateGridView();
   }

   protected void btnInit_Click(object sender, EventArgs e)
   {
      // Inicjalizacja buforów uzależniających.              
      Cache["Depend0"] = "To jest pierwsza zależność.";
      Cache["Depend1"] = "To jest druga zależność.";
      Cache["Depend2"] = "To jest trzecia zależność.";
   }

   protected void btnChange_Click(object sender, EventArgs e)
   {
      Cache["Depend0"] = "To jest zmieniona pierwsza zależność.";
   }
}
