﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CustomControls
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:CountedButton2 runat=server></{0}:CountedButton2>")]
    public class CountedButton2 : Button
    {
        private string displayString;

        // Domyślny konstruktor.
        public CountedButton2()
        {
            displayString = "kliknięć";
            InitValues();
        }

        // Przeciążona, pobiera ciąg znakowy do wyświetlenia (na przykład, 5) książek.
        public CountedButton2(string text)
        {
            displayString = text;
            InitValues();
        }

        // Wywołana przez konstruktora.
        private void InitValues()
        {
            if (ViewState["Count"] == null)
            {
                Count = 0;
            }
            Text = "Kliknij przycisk";
        }

        // count as property maintained in view state
        public int Count
        {
            get
            {
                return (int)ViewState["Count"];
            }

            set
            {
                ViewState["Count"] = value;
            }
        }

        // Unieważniamy zdarzenie OnClick, aby zwiększyć Count o jednostkę,
        // uaktualniamy tekst przycisku i wywołujemy metodę podstawową.
        protected override void OnClick(EventArgs e)
        {
            Count = Count + 1;
            Text = Count.ToString() + " " + displayString;
            base.OnClick(e);
        }
    }
}
