﻿Imports System.Data
Imports System.Data.SqlClient

Partial Class SimpleDataReader
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
        ' Tworzymy ciąg znakowy połączenia.
        Dim connectionString As String = "Data Source=(local)\sql2k5;Initial Catalog=AdventureWorksLT;" & "Integrated Security=True"

        Dim commandString As String = "Select [CustomerId], [FirstName], [LastName], [EmailAddress] from SalesLT.Customer"

        ' Tworzymy obiekt Connection.
        Dim conn As New SqlConnection(connectionString)

        ' Tworzymy obiekt Command.
        Dim command As New SqlCommand(commandString)

        ' Otwieramy połączenie.
        Try
            ' Otwieramy połączenie.
            conn.Open()

            ' Dołączamy obiekt Connection do obiektu Command.
            command.Connection = conn

            ' Pobieramy dane.           
            Dim reader As SqlDataReader = command.ExecuteReader(CommandBehavior.CloseConnection)

            ' Łączymy dane kontrolką GridView.
            GridView1.DataSource = reader
            GridView1.DataBind()
        Catch ex As Exception
            lblException.Text = ex.Message
        Finally
            ' Upewniamy się, że połączenie zostało zamknięte.
            If conn.State <> ConnectionState.Closed Then
                conn.Close()
            End If
        End Try

    End Sub


End Class
