using System;
using System.IO;		//  Niezbdne dla klasy Stream.
using System.Web.UI;
using System.Text;

public partial class FileUploadDemo : Page
{
    protected void btnSave_Click(object sender, EventArgs e)
    {
        StringBuilder str = new StringBuilder();
        if (FileUpload1.HasFile)
        {
            try
            {
                str.AppendFormat("Uploaded file: {0}", FileUpload1.FileName);

                //  Zapis pliku.
                FileUpload1.SaveAs("C:\\Users\\Robert\\Downloads\\" + FileUpload1.FileName);

                //  Pokazanie informacji dotyczcych pliku.
                str.AppendFormat("<br/>Zapisany jako: {0}", FileUpload1.PostedFile.FileName);
                str.AppendFormat("<br/>Typ pliku: {0}", FileUpload1.PostedFile.ContentType);
                str.AppendFormat("<br/>Wielko pliku (bajty): {0}", FileUpload1.PostedFile.ContentLength);
                str.AppendFormat("<br/>Nazwa pliku: {0}", FileUpload1.PostedFile.FileName);
            }
            catch (Exception ex)
            {
                str.Append("<br/><b>Bd</b><br/>");
                str.AppendFormat("Brak moliwoci zapisu w C:\\Users\\Robert\\Downloads\\{0}<br />{1}",
                    FileUpload1.FileName, ex.Message);
            }
        }
        else
        {
            lblMessage.Text = "Nie zosta przekazany aden plik.";
        }
        lblMessage.Text = str.ToString();
        lblDisplay.Text = "";
    }

    protected void btnDisplay_Click(object sender, EventArgs e)
    {
        StringBuilder str = new StringBuilder();
        str.AppendFormat("<u>Plik:  {0}</u><br/>", FileUpload1.FileName);
        if (FileUpload1.HasFile)
        {
            try
            {
                Stream stream = FileUpload1.FileContent;
                StreamReader reader = new StreamReader(stream);
                string strLine = "";
                do
                {
                    strLine = reader.ReadLine();
                    str.Append(strLine);
                } while (strLine != null);
            }
            catch (Exception ex)
            {
                str.AppendFormat("<br/><b>Bd</b><br/>");
                str.AppendFormat("Brak moliwoci wywietlenia {0}<br/>{1}", 
                    FileUpload1.FileName, ex.Message);
            }
        }
        else
        {
            lblDisplay.Text = "Nie zosta przekazany aden plik.";
        }
        lblDisplay.Text = str.ToString();
        lblMessage.Text = "";
    }
}