﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;

public partial class SimpleDataReader : Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      // Tworzymy ciąg znakowy połączenia.
      string connectionString =
          "Data Source=(local)\\sql2k5;Initial Catalog=AdventureWorksLT;" +
          "Integrated Security=True";

      string commandString = "Select [CustomerId], [FirstName], [LastName], [EmailAddress] from SalesLT.Customer";

      // Tworzymy obiekt Connection.
      SqlConnection conn = new SqlConnection(connectionString);

      // Tworzymy obiekt Command.
      SqlCommand command = new SqlCommand(commandString);

      // Otwieramy połączenie.
      try
      {
          // Otwieramy połączenie.
          conn.Open();

          // Dołączamy obiekt Connection do obiektu Command.
          command.Connection = conn;

          // Pobieramy dane.            
          SqlDataReader reader = command.ExecuteReader(CommandBehavior.CloseConnection);

          // Łączymy dane kontrolką GridView.
          GridView1.DataSource = reader;
          GridView1.DataBind();
      }
      catch (Exception ex)
      {
          lblException.Text = ex.Message;
      }
      finally
      {
         // Upewniamy się, że połączenie zostało zamknięte.
         if (conn.State != ConnectionState.Closed)
         {
            conn.Close();
         }
      }

   }
}
