﻿using System;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class CustomerDataList : UserControl
{
   public class ChangedRecordEventArgs : EventArgs
   {
      private string companyName;

      public string CompanyName
      {
         get { return companyName; }
      }

      public ChangedRecordEventArgs(string companyName)
      {
         this.companyName = companyName;
      }
   }

   private int numOfColumns = 3;
   private RepeatDirection direction = RepeatDirection.Horizontal;

   public int NumOfColumns
   {
      get { return numOfColumns; }
      set { numOfColumns = value; }
   }

   public RepeatDirection Direction
   {
      get { return direction; }
      set { direction = value; }
   }

   protected void Page_PreRender(object sender, EventArgs e)
   {
      DataList1.RepeatColumns = NumOfColumns;
      DataList1.RepeatDirection = Direction;
   }

   public delegate void EditRecordHandler(object sender, ChangedRecordEventArgs e);
   public event EditRecordHandler EditRecord;

   public delegate void FinishedEditRecordHandler(object sender, EventArgs e);
   public event FinishedEditRecordHandler FinishedEditRecord;

   protected virtual void OnEditRecord(ChangedRecordEventArgs e)
   {
      if (EditRecord != null)
      {
         EditRecord(this, e);
      }
   }

   protected virtual void OnFinishedEditRecord(EventArgs e)
   {
      if (FinishedEditRecord != null)
      {
         FinishedEditRecord(this, e);
      }
   }


   protected void DataList1_EditCommand(object source, DataListCommandEventArgs e)
   {
      DataList1.SelectedIndex = -1;
      DataList1.EditItemIndex = e.Item.ItemIndex;
      DataBind();

      // Wywołanie zdarzenia OnEditRecord.
      Label lbl = (Label) e.Item.FindControl("CompanyNameLabel");         
      string companyName = lbl.Text;         
      ChangedRecordEventArgs cre = new ChangedRecordEventArgs(companyName);         
      OnEditRecord(cre);
   }

   protected void DataList1_DeleteCommand(object source, DataListCommandEventArgs e)
   {
      // (1) Pobieramy recordID z zaznaczonego elementu.
      string recordID = (DataList1.DataKeys[e.Item.ItemIndex]).ToString();

      // (2) Pobieramy odniesienie do parametru customerID.
      Parameter param = dsCustomers.DeleteParameters["CustomerID"];

      // (3) Ustawiamy wartość default value parametru jako wartość
      // the record to delete
      param.DefaultValue = recordID;

      // (4) Usunięcie rekordu.
      dsCustomers.Delete();

      // (5) Ponowne dołączenie danych do kontrolki.
      DataBind();
   }
   protected void DataList1_UpdateCommand(object source, DataListCommandEventArgs e)
   {
      dsCustomers.UpdateParameters["CustomerID"].DefaultValue = (DataList1.DataKeys[e.Item.ItemIndex]).ToString();
      dsCustomers.UpdateParameters["NameStyle"].DefaultValue = ((CheckBox)e.Item.FindControl("NameStyleTextBox")).Checked.ToString();
      dsCustomers.UpdateParameters["Title"].DefaultValue = ((TextBox)e.Item.FindControl("TitleTextBox")).Text;
      dsCustomers.UpdateParameters["FirstName"].DefaultValue = ((TextBox)e.Item.FindControl("FirstNameTextBox")).Text;
      dsCustomers.UpdateParameters["MiddleName"].DefaultValue = ((TextBox)e.Item.FindControl("MiddleNameTextBox")).Text;
      dsCustomers.UpdateParameters["LastName"].DefaultValue = ((TextBox)e.Item.FindControl("LastNameTextBox")).Text;
      dsCustomers.UpdateParameters["Suffix"].DefaultValue = ((TextBox)e.Item.FindControl("SuffixTextBox")).Text;
      dsCustomers.UpdateParameters["CompanyName"].DefaultValue = ((TextBox)e.Item.FindControl("CompanyNameTextBox")).Text;
      dsCustomers.UpdateParameters["SalesPerson"].DefaultValue = ((TextBox)e.Item.FindControl("SalesPersonTextBox")).Text;
      dsCustomers.UpdateParameters["EmailAddress"].DefaultValue = ((TextBox)e.Item.FindControl("EmailAddressTextBox")).Text;
      dsCustomers.UpdateParameters["Phone"].DefaultValue = ((TextBox)e.Item.FindControl("PhoneTextBox")).Text;

      dsCustomers.Update();

      DataList1.EditItemIndex = -1;
      DataList1.DataBind();

      OnFinishedEditRecord(new EventArgs());
   }
   protected void DataList1_CancelCommand(object source, DataListCommandEventArgs e)
   {
      DataList1.EditItemIndex = -1;
      DataList1.SelectedIndex = -1;

      DataList1.DataBind();

      OnFinishedEditRecord(new EventArgs());
   }

   protected void DataList1_SelectedIndexChanged(object sender, EventArgs e)
   {
      StringBuilder info = new StringBuilder();
      info.AppendFormat("Przeglądanie rekordu {0} z {1} <br />",
         DataList1.SelectedIndex.ToString(), DataList1.Items.Count.ToString());
      info.AppendFormat("Przeglądanie rekordu {0} z {1} <br />",
         DataList1.SelectedIndex.ToString(), DataList1.DataKeys.Count);

      info.Append("Używając DataKey<br />");
      info.AppendFormat("{0} : {1}<br />", DataList1.DataKeyField, DataList1.SelectedValue.ToString());

      DataList1.DataBind();
   }
}
