﻿Imports System.IO

Partial Class FileUploadDemo
    Inherits System.Web.UI.Page


    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        Dim str As New StringBuilder()
        If FileUpload1.HasFile Then
            Try
                str.AppendFormat("Uploaded file: {0}", FileUpload1.FileName)

                ' Zapis pliku.
                FileUpload1.SaveAs("C:\Users\Robert\Downloads\" & FileUpload1.FileName)

                ' Pokazanie informacji dotyczących pliku.
                str.AppendFormat("<br/>Zapisany jako: {0}", FileUpload1.PostedFile.FileName)
                str.AppendFormat("<br/>Typ pliku: {0}", FileUpload1.PostedFile.ContentType)
                str.AppendFormat("<br/>Wielkość pliku (bajty): {0}", FileUpload1.PostedFile.ContentLength)
                str.AppendFormat("<br/>Nazwa pliku: {0}", FileUpload1.PostedFile.FileName)
            Catch ex As Exception
                str.Append("<br/><b>Błąd</b><br/>")
                str.AppendFormat("Brak możliwości zapisu w C:\Users\Robert\Downloads\{0}<br />{1}", FileUpload1.FileName, ex.Message)
            End Try
        Else
            lblMessage.Text = "Nie został przekazany żaden plik."
        End If
        lblMessage.Text = str.ToString()
        lblDisplay.Text = ""
    End Sub

    Protected Sub btnDisplay_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnDisplay.Click
        Dim str As New StringBuilder()
        str.AppendFormat("<u>Plik: {0}</u><br/>", FileUpload1.FileName)
        If FileUpload1.HasFile Then
            Try
                Dim stream As Stream = FileUpload1.FileContent
                Dim reader As New StreamReader(stream)
                Dim strLine As String = ""
                Do
                    strLine = reader.ReadLine()
                    str.Append(strLine)
                Loop While strLine IsNot Nothing
            Catch ex As Exception
                str.AppendFormat("<br/><b>Błąd</b><br/>")
                str.AppendFormat("Brak możliwości wyświetlenia {0}<br/>{1}", FileUpload1.FileName, ex.Message)
            End Try
        Else
            lblDisplay.Text = "Nie został przekazany żaden plik."
        End If
        lblDisplay.Text = str.ToString()
        lblMessage.Text = ""
    End Sub


End Class
