﻿using System;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System.Collections.Generic;
using System.Linq;
using TestMakerFreeWebApp.Data;
using Mapster;
using Microsoft.AspNetCore.Identity;
using Microsoft.Extensions.Configuration;

namespace TestMakerFreeWebApp.Controllers
{
   [Route("api/[controller]")]
   public class BaseApiController : Controller
   {
      #region Konstruktor
      public BaseApiController(ApplicationDbContext context,
         RoleManager<IdentityRole> roleManager,
         UserManager<ApplicationUser> userManager,
         IConfiguration configuration)
      {
         // Utwórz wymagane klasy wykorzystując wstrzykiwanie zależności
         DbContext = context;
         RoleManager = roleManager;
         UserManager = userManager;
         Configuration = configuration;

         // Utwórz pojedynczy obiekt JsonSerializerSettings,
         // który może być używany wielokrotnie
         JsonSettings = new JsonSerializerSettings()
         {
            Formatting = Formatting.Indented
         };

      }
      #endregion

      #region Współdzielone właściwości
      protected ApplicationDbContext DbContext { get; private set; }
      protected RoleManager<IdentityRole> RoleManager { get; private set; }
      protected UserManager<ApplicationUser> UserManager { get; private set; }
      protected IConfiguration Configuration { get; private set; }
      protected JsonSerializerSettings JsonSettings { get; private set; }
      #endregion
   }
}
