namespace WROX.ASPAJAX.Samples {
    using System;
    using System.Configuration;
    using System.Web;
    using System.Web.Profile;
    using System.Collections.Generic;

    public class MyProfileProvider : ProfileProvider {
        private Dictionary<string, Dictionary<string, object>> _index;

        public MyProfileProvider() {
            _index = new Dictionary<string, Dictionary<string, object>>();
        }

        public override SettingsPropertyValueCollection GetPropertyValues(SettingsContext context, SettingsPropertyCollection collection) {
            SettingsPropertyValueCollection settings = new SettingsPropertyValueCollection();
            foreach (SettingsProperty property in collection) {
                settings.Add(new SettingsPropertyValue(property));
            }

            string username = context["UserName"].ToString();
            Dictionary<string, object> userValues = null;
            lock (_index) {
                if (_index.TryGetValue(username, out userValues)) {
                    foreach (KeyValuePair<string, object> userValuePair in userValues) {
                        SettingsPropertyValue propertyValue = settings[userValuePair.Key];

                        if (propertyValue == null) {
                            continue;
                        }

                        propertyValue.PropertyValue = userValuePair.Value;
                        propertyValue.Deserialized = true;
                        propertyValue.IsDirty = false;
                    }
                }
            }
            return settings;
        }

        public override void SetPropertyValues(SettingsContext context, SettingsPropertyValueCollection collection) {
            string username = context["UserName"].ToString();
            bool authenticated = (bool)context["IsAuthenticated"];

            if (String.IsNullOrEmpty(username)) {
                return;
            }

            Dictionary<string, object> userValues = null;

            lock (_index) {
                if (!_index.TryGetValue(username, out userValues)) {
                    userValues = _index[username] = new Dictionary<string, object>();
                }

                foreach (SettingsPropertyValue propertyValue in collection) {
                    if (!authenticated && !(bool)propertyValue.Property.Attributes["AllowAnonymous"]) {
                        continue;
                    }
                    userValues[propertyValue.Name] = propertyValue.PropertyValue;
                }
            }
        }


        public override int DeleteProfiles(ProfileInfoCollection profiles) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override int DeleteProfiles(string[] usernames) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override int DeleteInactiveProfiles(ProfileAuthenticationOption authenticationOption, DateTime userInactiveSinceDate) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override int GetNumberOfInactiveProfiles(ProfileAuthenticationOption authenticationOption, DateTime userInactiveSinceDate) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override ProfileInfoCollection GetAllProfiles(ProfileAuthenticationOption authenticationOption, int pageIndex, int pageSize, out int totalRecords) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override ProfileInfoCollection GetAllInactiveProfiles(ProfileAuthenticationOption authenticationOption, DateTime userInactiveSinceDate, int pageIndex, int pageSize, out int totalRecords) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override ProfileInfoCollection FindProfilesByUserName(ProfileAuthenticationOption authenticationOption, string usernameToMatch, int pageIndex, int pageSize, out int totalRecords) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override ProfileInfoCollection FindInactiveProfilesByUserName(ProfileAuthenticationOption authenticationOption, string usernameToMatch, DateTime userInactiveSinceDate, int pageIndex, int pageSize, out int totalRecords) {
            throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
        }

        public override string ApplicationName {
            get {
                throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
            }
            set {
                throw new Exception("Metoda lub operacja nie jest zaimplementowana.");
            }
        }
    }
}
