﻿<%@ WebService Language="C#" Class="AlbumProxy" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Web.Script.Services;
using System.Net;
using System.Xml.Serialization;
using System.Web.Script.Serialization;

public class Album
{
    private string _artist = String.Empty;
    private string _title = String.Empty;
    private int _releaseYear;
    private string[] _tracks = new string[17];
    private DateTime _dateTime = DateTime.Now;
    private string _personalInfo = "nie pokazuj tego";

    [ScriptIgnore()]
    public string PersonalInfo
    {
        get {
            return _personalInfo;
        }
        set {
            _personalInfo = value;
        }
    }

    public Album() {
    }

    public DateTime Date {
        get
        {
            return _dateTime;
        }
    }

    public string Artist {
        get {
            return _artist;
        }
        set {
            _artist = value;
        }
    }

    public string Title {
        get {
            return _title;
        }
        set {
            _title = value;
        }
    }

    public int ReleaseYear {
        get {
            return _releaseYear;
        }
        set {
            _releaseYear = value;
        }
    }

    public string[] Tracks {
        get {
            return _tracks;
        }
        set {
            _tracks = value;
        }
    }
}

[ScriptService]
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class AlbumProxy : System.Web.Services.WebService {

    private Album _album;
    
    public AlbumProxy() {
        _album = new Album();
        _album.Artist = "Fisz Envee";
        _album.Title = "Fru!";
        _album.ReleaseYear = 2005;
        _album.Tracks.SetValue("Idzie miłość", 0);
        _album.Tracks.SetValue("Chodźmy w deszcz", 1);
        _album.Tracks.SetValue("Do Pani", 2);
        _album.Tracks.SetValue("Kuchnia", 3);
        _album.Tracks.SetValue("Gemba - skit", 4);
        _album.Tracks.SetValue("Tłusty bit", 5);
        _album.Tracks.SetValue("Sanszajn - skit", 6);
        _album.Tracks.SetValue("Kryminalny Bluez", 7);
        _album.Tracks.SetValue("Bluez - skit", 8);
        _album.Tracks.SetValue("Pan Trup", 9);
        _album.Tracks.SetValue("Kręcioł", 10);
        _album.Tracks.SetValue("Bosa - skit", 11);
        _album.Tracks.SetValue("Ziółko", 12);
        _album.Tracks.SetValue("Gnój", 13);
        _album.Tracks.SetValue("Aj Gary Glu", 14);
        _album.Tracks.SetValue("Błękit nieba - skit", 15);
        _album.Tracks.SetValue("Leć", 16);
    }

    [WebMethod]
    [XmlInclude(typeof(Album))]
    public object GetAlbum() {
        return _album;
    }

    [WebMethod]
    [XmlInclude(typeof(Album))]
    public object GetAlbumJSON()
    {
        JavaScriptSerializer serializer = new JavaScriptSerializer();
        return serializer.Serialize(_album);
    }        
}
