/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v7.internal.widget.DrawableWrapper;
import android.support.v7.internal.widget.TintManager;

class TintDrawableWrapper
extends DrawableWrapper {
    private final ColorStateList mTintStateList;
    private final PorterDuff.Mode mTintMode;
    private int mCurrentColor;

    public TintDrawableWrapper(Drawable drawable2, ColorStateList tintStateList) {
        this(drawable2, tintStateList, TintManager.DEFAULT_MODE);
    }

    public TintDrawableWrapper(Drawable drawable2, ColorStateList tintStateList, PorterDuff.Mode tintMode) {
        super(drawable2);
        this.mTintStateList = tintStateList;
        this.mTintMode = tintMode;
    }

    @Override
    public boolean isStateful() {
        return this.mTintStateList != null && this.mTintStateList.isStateful() || super.isStateful();
    }

    @Override
    public boolean setState(int[] stateSet) {
        boolean handled = super.setState(stateSet);
        handled = this.updateTint(stateSet) || handled;
        return handled;
    }

    private boolean updateTint(int[] state) {
        int color;
        if (this.mTintStateList != null && (color = this.mTintStateList.getColorForState(state, this.mCurrentColor)) != this.mCurrentColor) {
            if (color != 0) {
                this.setColorFilter(color, this.mTintMode);
            } else {
                this.clearColorFilter();
            }
            this.mCurrentColor = color;
            return true;
        }
        return false;
    }
}

