/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.internal.text.AllCapsTransformationMethod;
import android.support.v7.internal.widget.TintManager;
import android.support.v7.internal.widget.TintTypedArray;
import android.support.v7.internal.widget.ViewUtils;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.CompoundButton;

public class SwitchCompat
extends CompoundButton {
    private static final int THUMB_ANIMATION_DURATION = 250;
    private static final int TOUCH_MODE_IDLE = 0;
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAGGING = 2;
    private static final int[] TEXT_APPEARANCE_ATTRS = new int[]{16842904, 16842901, R.attr.textAllCaps};
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private Drawable mThumbDrawable;
    private Drawable mTrackDrawable;
    private int mThumbTextPadding;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private boolean mSplitTrack;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private boolean mShowText;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();
    private int mMinFlingVelocity;
    private float mThumbPosition;
    private int mSwitchWidth;
    private int mSwitchHeight;
    private int mThumbWidth;
    private int mSwitchLeft;
    private int mSwitchTop;
    private int mSwitchRight;
    private int mSwitchBottom;
    private TextPaint mTextPaint;
    private ColorStateList mTextColors;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private TransformationMethod mSwitchTransformationMethod;
    private Animation mPositionAnimator;
    private final Rect mTempRect = new Rect();
    private final TintManager mTintManager;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public SwitchCompat(Context context) {
        this(context, null);
    }

    public SwitchCompat(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.switchStyle);
    }

    public SwitchCompat(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mTextPaint = new TextPaint(1);
        Resources res = this.getResources();
        this.mTextPaint.density = res.getDisplayMetrics().density;
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(context, attrs, R.styleable.SwitchCompat, defStyleAttr, 0);
        this.mThumbDrawable = a.getDrawable(R.styleable.SwitchCompat_android_thumb);
        this.mTrackDrawable = a.getDrawable(R.styleable.SwitchCompat_track);
        this.mTextOn = a.getText(R.styleable.SwitchCompat_android_textOn);
        this.mTextOff = a.getText(R.styleable.SwitchCompat_android_textOff);
        this.mShowText = a.getBoolean(R.styleable.SwitchCompat_showText, true);
        this.mThumbTextPadding = a.getDimensionPixelSize(R.styleable.SwitchCompat_thumbTextPadding, 0);
        this.mSwitchMinWidth = a.getDimensionPixelSize(R.styleable.SwitchCompat_switchMinWidth, 0);
        this.mSwitchPadding = a.getDimensionPixelSize(R.styleable.SwitchCompat_switchPadding, 0);
        this.mSplitTrack = a.getBoolean(R.styleable.SwitchCompat_splitTrack, false);
        int appearance = a.getResourceId(R.styleable.SwitchCompat_switchTextAppearance, 0);
        if (appearance != 0) {
            this.setSwitchTextAppearance(context, appearance);
        }
        this.mTintManager = a.getTintManager();
        a.recycle();
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mMinFlingVelocity = config.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
    }

    public void setSwitchTextAppearance(Context context, int resid) {
        boolean allCaps;
        TypedArray appearance = context.obtainStyledAttributes(resid, TEXT_APPEARANCE_ATTRS);
        ColorStateList colors = appearance.getColorStateList(0);
        this.mTextColors = colors != null ? colors : this.getTextColors();
        int ts = appearance.getDimensionPixelSize(1, 0);
        if (ts != 0 && (float)ts != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize((float)ts);
            this.requestLayout();
        }
        this.mSwitchTransformationMethod = (allCaps = appearance.getBoolean(2, false)) ? new AllCapsTransformationMethod(this.getContext()) : null;
        appearance.recycle();
    }

    public void setSwitchTypeface(Typeface tf, int style) {
        if (style > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)tf, (int)style);
            this.setSwitchTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(tf);
        }
    }

    public void setSwitchTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setSwitchPadding(int pixels) {
        this.mSwitchPadding = pixels;
        this.requestLayout();
    }

    public int getSwitchPadding() {
        return this.mSwitchPadding;
    }

    public void setSwitchMinWidth(int pixels) {
        this.mSwitchMinWidth = pixels;
        this.requestLayout();
    }

    public int getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    public void setThumbTextPadding(int pixels) {
        this.mThumbTextPadding = pixels;
        this.requestLayout();
    }

    public int getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    public void setTrackDrawable(Drawable track) {
        this.mTrackDrawable = track;
        this.requestLayout();
    }

    public void setTrackResource(int resId) {
        this.setTrackDrawable(this.mTintManager.getDrawable(resId));
    }

    public Drawable getTrackDrawable() {
        return this.mTrackDrawable;
    }

    public void setThumbDrawable(Drawable thumb) {
        this.mThumbDrawable = thumb;
        this.requestLayout();
    }

    public void setThumbResource(int resId) {
        this.setThumbDrawable(this.mTintManager.getDrawable(resId));
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public void setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public void setTextOn(CharSequence textOn) {
        this.mTextOn = textOn;
        this.requestLayout();
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public void setTextOff(CharSequence textOff) {
        this.mTextOff = textOff;
        this.requestLayout();
    }

    public void setShowText(boolean showText) {
        if (this.mShowText != showText) {
            this.mShowText = showText;
            this.requestLayout();
        }
    }

    public boolean getShowText() {
        return this.mShowText;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int trackHeight;
        int thumbHeight;
        int thumbWidth;
        if (this.mShowText) {
            if (this.mOnLayout == null) {
                this.mOnLayout = this.makeLayout(this.mTextOn);
            }
            if (this.mOffLayout == null) {
                this.mOffLayout = this.makeLayout(this.mTextOff);
            }
        }
        Rect padding = this.mTempRect;
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(padding);
            thumbWidth = this.mThumbDrawable.getIntrinsicWidth() - padding.left - padding.right;
            thumbHeight = this.mThumbDrawable.getIntrinsicHeight();
        } else {
            thumbWidth = 0;
            thumbHeight = 0;
        }
        int maxTextWidth = this.mShowText ? Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth()) + this.mThumbTextPadding * 2 : 0;
        this.mThumbWidth = Math.max(maxTextWidth, thumbWidth);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(padding);
            trackHeight = this.mTrackDrawable.getIntrinsicHeight();
        } else {
            padding.setEmpty();
            trackHeight = 0;
        }
        int paddingLeft = padding.left;
        int paddingRight = padding.right;
        int switchWidth = Math.max(this.mSwitchMinWidth, 2 * this.mThumbWidth + paddingLeft + paddingRight);
        int switchHeight = Math.max(trackHeight, thumbHeight);
        this.mSwitchWidth = switchWidth;
        this.mSwitchHeight = switchHeight;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredHeight = this.getMeasuredHeight();
        if (measuredHeight < switchHeight) {
            this.setMeasuredDimension(ViewCompat.getMeasuredWidthAndState((View)this), switchHeight);
        }
    }

    @TargetApi(value=14)
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        CharSequence text;
        super.onPopulateAccessibilityEvent(event);
        CharSequence charSequence = text = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (text != null) {
            event.getText().add(text);
        }
    }

    private Layout makeLayout(CharSequence text) {
        CharSequence transformed = this.mSwitchTransformationMethod != null ? this.mSwitchTransformationMethod.getTransformation(text, (View)this) : text;
        return new StaticLayout(transformed, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)transformed, (TextPaint)this.mTextPaint)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    private boolean hitThumb(float x, float y) {
        int thumbOffset = this.getThumbOffset();
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbTop = this.mSwitchTop - this.mTouchSlop;
        int thumbLeft = this.mSwitchLeft + thumbOffset - this.mTouchSlop;
        int thumbRight = thumbLeft + this.mThumbWidth + this.mTempRect.left + this.mTempRect.right + this.mTouchSlop;
        int thumbBottom = this.mSwitchBottom + this.mTouchSlop;
        return x > (float)thumbLeft && x < (float)thumbRight && y > (float)thumbTop && y < (float)thumbBottom;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mVelocityTracker.addMovement(ev);
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                if (!this.isEnabled() || !this.hitThumb(x, y)) break;
                this.mTouchMode = 1;
                this.mTouchX = x;
                this.mTouchY = y;
                break;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        float x = ev.getX();
                        float y = ev.getY();
                        if (!(Math.abs(x - this.mTouchX) > (float)this.mTouchSlop) && !(Math.abs(y - this.mTouchY) > (float)this.mTouchSlop)) break;
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = x;
                        this.mTouchY = y;
                        return true;
                    }
                    case 2: {
                        float newPos;
                        float dPos;
                        float x = ev.getX();
                        int thumbScrollRange = this.getThumbScrollRange();
                        float thumbScrollOffset = x - this.mTouchX;
                        if (thumbScrollRange != 0) {
                            dPos = thumbScrollOffset / (float)thumbScrollRange;
                        } else {
                            float f = dPos = thumbScrollOffset > 0.0f ? 1.0f : -1.0f;
                        }
                        if (ViewUtils.isLayoutRtl((View)this)) {
                            dPos = -dPos;
                        }
                        if ((newPos = SwitchCompat.constrain(this.mThumbPosition + dPos, 0.0f, 1.0f)) != this.mThumbPosition) {
                            this.mTouchX = x;
                            this.setThumbPosition(newPos);
                        }
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mTouchMode == 2) {
                    this.stopDrag(ev);
                    super.onTouchEvent(ev);
                    return true;
                }
                this.mTouchMode = 0;
                this.mVelocityTracker.clear();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void cancelSuperTouch(MotionEvent ev) {
        MotionEvent cancel = MotionEvent.obtain((MotionEvent)ev);
        cancel.setAction(3);
        super.onTouchEvent(cancel);
        cancel.recycle();
    }

    private void stopDrag(MotionEvent ev) {
        boolean newState;
        boolean commitChange;
        this.mTouchMode = 0;
        boolean bl = commitChange = ev.getAction() == 1 && this.isEnabled();
        if (commitChange) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            float xvel = this.mVelocityTracker.getXVelocity();
            newState = Math.abs(xvel) > (float)this.mMinFlingVelocity ? (ViewUtils.isLayoutRtl((View)this) ? xvel < 0.0f : xvel > 0.0f) : this.getTargetCheckedState();
        } else {
            newState = this.isChecked();
        }
        this.setChecked(newState);
        this.cancelSuperTouch(ev);
    }

    private void animateThumbToCheckedState(boolean newCheckedState) {
        final float startPosition = this.mThumbPosition;
        float targetPosition = newCheckedState ? 1.0f : 0.0f;
        final float diff = targetPosition - startPosition;
        this.mPositionAnimator = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                SwitchCompat.this.setThumbPosition(startPosition + diff * interpolatedTime);
            }
        };
        this.mPositionAnimator.setDuration(250L);
        this.startAnimation(this.mPositionAnimator);
    }

    private void cancelPositionAnimator() {
        if (this.mPositionAnimator != null) {
            this.clearAnimation();
            this.mPositionAnimator = null;
        }
    }

    private boolean getTargetCheckedState() {
        return this.mThumbPosition > 0.5f;
    }

    private void setThumbPosition(float position) {
        this.mThumbPosition = position;
        this.invalidate();
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        checked = this.isChecked();
        if (this.getWindowToken() != null) {
            this.animateThumbToCheckedState(checked);
        } else {
            this.cancelPositionAnimator();
            this.setThumbPosition(checked ? 1.0f : 0.0f);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int switchBottom;
        int switchTop;
        int switchRight;
        int switchLeft;
        super.onLayout(changed, left, top, right, bottom);
        int opticalInsetLeft = 0;
        int opticalInsetRight = 0;
        if (this.mThumbDrawable != null) {
            Rect trackPadding = this.mTempRect;
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.getPadding(trackPadding);
            } else {
                trackPadding.setEmpty();
            }
            opticalInsetLeft = 0;
            opticalInsetRight = 0;
        }
        if (ViewUtils.isLayoutRtl((View)this)) {
            switchLeft = this.getPaddingLeft() + opticalInsetLeft;
            switchRight = switchLeft + this.mSwitchWidth - opticalInsetLeft - opticalInsetRight;
        } else {
            switchRight = this.getWidth() - this.getPaddingRight() - opticalInsetRight;
            switchLeft = switchRight - this.mSwitchWidth + opticalInsetLeft + opticalInsetRight;
        }
        switch (this.getGravity() & 0x70) {
            default: {
                switchTop = this.getPaddingTop();
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 16: {
                switchTop = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 80: {
                switchBottom = this.getHeight() - this.getPaddingBottom();
                switchTop = switchBottom - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = switchLeft;
        this.mSwitchTop = switchTop;
        this.mSwitchBottom = switchBottom;
        this.mSwitchRight = switchRight;
    }

    public void draw(Canvas c) {
        Rect padding = this.mTempRect;
        int switchLeft = this.mSwitchLeft;
        int switchTop = this.mSwitchTop;
        int switchRight = this.mSwitchRight;
        int switchBottom = this.mSwitchBottom;
        int thumbInitialLeft = switchLeft + this.getThumbOffset();
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(padding);
            thumbInitialLeft += padding.left;
            int trackLeft = switchLeft;
            int trackTop = switchTop;
            int trackRight = switchRight;
            int trackBottom = switchBottom;
            this.mTrackDrawable.setBounds(trackLeft, trackTop, trackRight, trackBottom);
        }
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(padding);
            int thumbLeft = thumbInitialLeft - padding.left;
            int thumbRight = thumbInitialLeft + this.mThumbWidth + padding.right;
            this.mThumbDrawable.setBounds(thumbLeft, switchTop, thumbRight, switchBottom);
            Drawable background = this.getBackground();
            if (background != null) {
                DrawableCompat.setHotspotBounds((Drawable)background, (int)thumbLeft, (int)switchTop, (int)thumbRight, (int)switchBottom);
            }
        }
        super.draw(c);
    }

    protected void onDraw(Canvas canvas) {
        Layout switchText;
        super.onDraw(canvas);
        Rect padding = this.mTempRect;
        Drawable trackDrawable = this.mTrackDrawable;
        if (trackDrawable != null) {
            trackDrawable.getPadding(padding);
        } else {
            padding.setEmpty();
        }
        int switchTop = this.mSwitchTop;
        int switchBottom = this.mSwitchBottom;
        int switchInnerTop = switchTop + padding.top;
        int switchInnerBottom = switchBottom - padding.bottom;
        Drawable thumbDrawable = this.mThumbDrawable;
        if (trackDrawable != null) {
            trackDrawable.draw(canvas);
        }
        int saveCount = canvas.save();
        if (thumbDrawable != null) {
            thumbDrawable.draw(canvas);
        }
        Layout layout2 = switchText = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout;
        if (switchText != null) {
            int cX;
            int[] drawableState = this.getDrawableState();
            if (this.mTextColors != null) {
                this.mTextPaint.setColor(this.mTextColors.getColorForState(drawableState, 0));
            }
            this.mTextPaint.drawableState = drawableState;
            if (thumbDrawable != null) {
                Rect bounds = thumbDrawable.getBounds();
                cX = bounds.left + bounds.right;
            } else {
                cX = this.getWidth();
            }
            int left = cX / 2 - switchText.getWidth() / 2;
            int top = (switchInnerTop + switchInnerBottom) / 2 - switchText.getHeight() / 2;
            canvas.translate((float)left, (float)top);
            switchText.draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    public int getCompoundPaddingLeft() {
        if (!ViewUtils.isLayoutRtl((View)this)) {
            return super.getCompoundPaddingLeft();
        }
        int padding = super.getCompoundPaddingLeft() + this.mSwitchWidth;
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    public int getCompoundPaddingRight() {
        if (ViewUtils.isLayoutRtl((View)this)) {
            return super.getCompoundPaddingRight();
        }
        int padding = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    private int getThumbOffset() {
        float thumbPosition = ViewUtils.isLayoutRtl((View)this) ? 1.0f - this.mThumbPosition : this.mThumbPosition;
        return (int)(thumbPosition * (float)this.getThumbScrollRange() + 0.5f);
    }

    private int getThumbScrollRange() {
        if (this.mTrackDrawable != null) {
            Rect padding = this.mTempRect;
            this.mTrackDrawable.getPadding(padding);
            return this.mSwitchWidth - this.mThumbWidth - padding.left - padding.right;
        }
        return 0;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            SwitchCompat.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] myDrawableState = this.getDrawableState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setState(myDrawableState);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setState(myDrawableState);
        }
        this.invalidate();
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumbDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mThumbDrawable, (float)x, (float)y);
        }
        if (this.mTrackDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mTrackDrawable, (float)x, (float)y);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mThumbDrawable || who == this.mTrackDrawable;
    }

    public void jumpDrawablesToCurrentState() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.jumpDrawablesToCurrentState();
            if (this.mThumbDrawable != null) {
                this.mThumbDrawable.jumpToCurrentState();
            }
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.jumpToCurrentState();
            }
            if (this.mPositionAnimator != null && this.mPositionAnimator.hasStarted() && !this.mPositionAnimator.hasEnded()) {
                this.clearAnimation();
                this.mPositionAnimator = null;
            }
        }
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)SwitchCompat.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        if (Build.VERSION.SDK_INT >= 14) {
            CharSequence switchText;
            super.onInitializeAccessibilityNodeInfo(info);
            info.setClassName((CharSequence)SwitchCompat.class.getName());
            CharSequence charSequence = switchText = this.isChecked() ? this.mTextOn : this.mTextOff;
            if (!TextUtils.isEmpty((CharSequence)switchText)) {
                CharSequence oldText = info.getText();
                if (TextUtils.isEmpty((CharSequence)oldText)) {
                    info.setText(switchText);
                } else {
                    StringBuilder newText = new StringBuilder();
                    newText.append(oldText).append(' ').append(switchText);
                    info.setText((CharSequence)newText);
                }
            }
        }
    }

    private static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

