# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 14: Kontenery

**Ostrzeżenie**: Konfiguracja katalogu . Zanim wydasz w nim polecenie `direnv allow`
upewnij się, że masz dostęp superużytkownika przy użyciu narzędzia `sudo` i sporządź kopie zapasowe plików, które zostaną
zmodyfikowane (`/etc/containers/policy.json`, `/etc/containers/registries.conf`,
`$HOME/podman.conf`)

### Kontenery

Podkatalog `containers` zawiera przykłady różnych sposobów budowania kontenerów.

#### Docker

```
cd containers/docker
docker build -t basic -f basic.Dockerfile .
docker build -t compile -f compile.Dockerfile .
docker build -t multi-stage -f multi-stage.Dockerfile .
docker build -t scratch -f scratch.Dockerfile .
```

Po zbudowaniu obrazu kontenera, powinien on znaleźć się na liście wyświetlanej po wydaniu polecenia `docker
images`, powinien być tam wymieniony nowy obraz.

Do uruchomienia przykładów `compile` i `multi-stage` konieczna jest obecność w bieżącym katalogu kopii plików źródłowych w języku C++. 
Do uruchomienia przykładu `scratch` niezbędne jest umieszczenie w katalogu roboczym
pliku binarnego.

Aby zbudować statyczny plik binarny, możesz użyć następujących poleceń:

```
conan install .. --build=missing -s build_type=Release -pr=hosacpp
cmake .. -DCMAKE_BUILD_TYPE=Release -DCMAKE_EXE_LINKER_FLAGS="-static" -DBUILD_SHARED_LIBS=OFF -DCMAKE_FIND_LIBRARY_SUFFIXES=".a"
cmake --build .
```

#### Buildah

Aby zbudować obraz przy użyciu skryptu powłoki, wydaj polecenie `./buildah.sh`. Zbudowany
obraz możesz zobaczyć po uruchomieniu polecenia `podman images`. Nosi on nazwę
`localhost/dominican-gcc`.

```
cd containers/buildah
./buildah.sh
```

#### Ansible Bender

Aby zbudować obraz za pomocą narzędzia ansible-bender, wydaj polecenia

```
cd containers/ansible-bender
ansible-bender build bender.yaml
```

Narzędzie Ansible Bender nie ma jeszcze wersji stabilej, więc jeśli napotkasz błędy, np.
`ERROR  Getting image source signatures`, zatrzymaj budowę i przeprowadź ją ponownie.

Zbudowany obraz możesz zobaczyć po uruchomieniu polecenia `podman images`. Nosi on nazwę
`localhost/dominican-compiler`.

### Orkiestracja

Kod znajdujący się w podkatalogu `orchestration` ma na celu tylko zilustrowanie tematu i
nie powinien być bezpośrednio używany.
