# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 9: Ciągła integracja i ciągłe wdrażanie

### Packer

Aby wypróbować kod związany z narzędziami Packer i Terraform, będziesz potrzebować konta AWS. Na stronie
 https://aws.amazon.com/ możesz uzyskać darmową wersję próbną.

W celu uzyskania poświadczeń postępuj według wskazań dokumentu:
https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/getting-your-credentials.html
.

Jeśli tworzysz nowe konto użytkownika tylko na potrzeby testów, możesz dołączyć do niego
zasady `AdministratorAccess`. W zastosowaniach produkcyjnych nadawaj
uprawnienia w sposób precyzyjny.

Nadaj zmiennym środowiskowym wartości uzyskane z usługi IAM:

```
export AWS_ACCESS_KEY_ID="anaccesskey"
export AWS_SECRET_ACCESS_KEY="asecretkey"
```

Jeśli korzystasz z narzędzia Direnv, możesz też umieścić te zmienne w pliku `.env` w
bieżącym katalogu. Wprowadź swoje klucze tajne do pliku `env.example` i zmień jego rozszerzenie
na `.env`.

Skonfiguruj interfejs CLI platformy AWS (według wskazań samouczka: https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html) i wydaj polecenie `aws configure`

Aby zbudować obraz przy użyciu narzędzia Packer, wydaj polecenie:

```
packer build packer_ami.json
```

Gdy narzędzie Packer zakończy pracę, zapisz nazwę utworzonego obrazu AMI. Będziesz musiał jej użyć w narzędziu
Terraform. Obraz AMI może mieć na przykład nazwę: ami-0f89d498d96a38d2f

**Ważne**: Koniecznie wyczyść wszystkie
zasoby chmury. Zaloguj się do konsoli internetowej platformy AWS i usuń
wszystkie obrazy AMI i migawki:
https://eu-central-1.console.aws.amazon.com/ec2/v2/home?region=eu-central-1#Images:sort=name
. W przeciwnym razie platforma AWS naliczy Ci opłaty za używane zasoby.

### Tworzenie zasobów przy użyciu narzędzia Terraform

Najpierw musisz zainicjować stan narzędzia Terraform:

```
terraform init
```

Aby zobaczyć, jakie zasoby zostały utworzone, wydaj polecenie `terraform plan`. Ustaw zmienne tak, by
wskazywały obrazy AMI utworzone za pomocą narzędzia Packer i wymagany region (region
zasobów Terraform musi być taki sam, jak region obrazu AMI użyty w narzędziu Packer).
Oto przykład:

```
terraform plan -var packer_ami=ami-0f89d498d96a38d2f -var region=eu-central-1
```

Terraform użyje domyślnej pary kluczy obecnej w Twoim katalogu domowym.
Jeśli nie masz pary kluczy SSH, możesz utworzyć ją przez wydanie polecenia
`ssh-keygen -t rsa -m PEM`

Możesz też użyć istniejącej pary kluczy, jeśli pokierujesz się wskazaniami dokumentu: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws

Aby utworzyć zasoby na swoim koncie, wydaj polecenie:

```
terraform apply -var packer_ami=ami-0f89d498d96a38d2f -var region=eu-central-1
```

**Ważne**: po wszystkim wydaj koniecznie polecenie `terraform destroy` w celu wyczyszczenia wszystkich
zasobów utworzonych przez narzędzie Terraform. Zaloguj się też do konsoli internetowej platformy AWS i usuń
wszystkie obrazy AMI i migawki:
https://eu-central-1.console.aws.amazon.com/ec2/v2/home?region=eu-central-1#Images:sort=name
. W przeciwnym razie platforma AWS naliczy Ci opłaty za używane zasoby.

```
terraform destroy -var packer_ami=ami-0f89d498d96a38d2f -var region=eu-central-1
```

### BDD

Kod w podkatalogu `bdd` ma na celu tylko zilustrowanie tematu i nie powinien
być bezpośrednio budowany.
