# .rst: FindMyDep
# ----------
#
# Znajdź moją ulubioną zewnętrzną zależność (MyDep).
#
# Importowane cele
# ^^^^^^^^^^^^^^^^
#
# W module tym definiuje się następujący cel o właściwości :prop_tgt:`IMPORTED`:
#
# ``MyDep::MyDep`` biblioteka MyDep, o ile zostanie znaleziona.
#
# Zmienne wynikowe
# ^^^^^^^^^^^^^^^^
#
# Kod tego modułu ustawia następujące zmienne w projekcie:
#
# ``MyDep_FOUND`` informuje, czy znaleziono bibliotekę MyDep ``MyDep_VERSION`` znaleziona
# wersja biblioteki MyDep

find_package(Boost REQUIRED)

find_package(PkgConfig)
pkg_check_modules(PC_MyDep QUIET MyDep)

find_path(
  MyDep_INCLUDE_DIR
  NAMES MyDep.h
  PATHS "${MyDep_ROOT_DIR}/include" "${PC_MyDep_INCLUDE_DIRS}"
  PATH_SUFFIXES MyDep)

find_library(
  MyDep_LIBRARY
  NAMES mydep
  PATHS "${MyDep_ROOT_DIR}/lib" "${PC_MyDep_LIBRARY_DIRS}")

set(MyDep_VERSION ${PC_MyDep_VERSION})

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(
  MyDep
  FOUND_VAR
  MyDep_FOUND
  REQUIRED_VARS
  MyDep_LIBRARY
  MyDep_INCLUDE_DIR
  VERSION_VAR
  MyDep_VERSION)

if(MyDep_FOUND AND NOT TARGET MyDep::MyDep)
  add_library(MyDep::MyDep UNKNOWN IMPORTED)
  set_target_properties(
    MyDep::MyDep
    PROPERTIES IMPORTED_LOCATION "${MyDep_LIBRARY}" INTERFACE_COMPILE_OPTIONS
                                                    "${PC_MyDep_CFLAGS_OTHER}"
               INTERFACE_INCLUDE_DIRECTORIES "${MyDep_INCLUDE_DIR}")
endif()

mark_as_advanced(MyDep_INCLUDE_DIR MyDep_LIBRARY)
