# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 7: Budowanie i pakowanie

### Wymagania wstępne

Zainstaluj następujące oprogramowanie:
- CMake 3.15
- Conan 1.43
- GCC 10

Jeśli pracujesz w systemie Linux albo korzystasz z WSL, skonfiguruj profil narzędzia Conan o nazwie hosacpp i elementy zdalne przez wydanie poleceń:

```bash
conan profile new hosacpp || true
conan profile update settings.compiler=gcc hosacpp
conan profile update settings.compiler.libcxx=libstdc++11 hosacpp
conan profile update settings.compiler.version=10 hosacpp
conan profile update settings.arch=x86_64 hosacpp
conan profile update settings.os=Linux hosacpp
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 10, musisz też dodać:

```bash
conan profile update env.CXX=`which g++-10` hosacpp
conan profile update env.CC=`which gcc-10` hosacpp
```

### Budowanie

Aby zbudować projekt customer, przejdź najpierw poleceniem cd do jego katalogu źródłowego, a potem uruchom:

```bash
mkdir build
cd build
conan install .. --build=missing -s build_type=Release -pr=hosacpp
cmake .. -DCMAKE_BUILD_TYPE=Release # typ budowy musi odpowiadać temu z narzędzia Conan
cmake --build .
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 10, możesz nakazać narzędziu CMake go użyć za pomogą flagi `CMAKE_CXX_COMPILER`.
Zamień pierwsze z powyższych wywołań na:

```bash
cmake .. -DCMAKE_BUILD_TYPE=Release -DCMAKE_CXX_COMPILER=`which g++-10`
```


### Testowanie

Aby uruchomić testy poszczególnych projektów, przejdź poleceniem cd do odpowiedniego katalogu build, a potem uruchom po prostu narzędzie `ctest`.

### Instalowanie

W katalogu build wydaj polecenie `cmake --install .`, a oprogramowanie zostanie zainstalowane na ścieżce `${CMAKE_PREFIX_PATH}`. Jeśli nie zostanie podany żaden prefiks,
, instalacja nastąpi na poziomie całego systemu. Aby to zmienić, dodaj do wywołania narzędzia cmake flagę `-DCMAKE_INSTALL_PREFIX=/ścieżka/do/instalacji`.

### Pakowanie

W katalogu build uruchom narzędzie `cpack`. To wystarczy. Jeśli pracujesz w systemie obsługującym pakiety DEB,
otrzymasz plik .tar.gz, plik .zip i pakiet .deb.

### Budowanie pakietu Conan

W katalogu build wydaj polecenie `cmake --build . --target conan`.
