# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 12: Architektura zorientowana na usługi

### Wymagania wstępne

Zainstaluj następujące oprogramowanie:
- CMake 3.15
- Conan 1.43
- GCC 10

Jeśli pracujesz w systemie Linux albo korzystasz z WSL, skonfiguruj profil narzędzia Conan o nazwie hosacpp i elementy zdalne przez wydanie poleceń:

```bash
conan profile new hosacpp || true
conan profile update settings.compiler=gcc hosacpp
conan profile update settings.compiler.libcxx=libstdc++11 hosacpp
conan profile update settings.compiler.version=10 hosacpp
conan profile update settings.arch=x86_64 hosacpp
conan profile update settings.os=Linux hosacpp
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 10, musisz też dodać:

```bash
conan profile update env.CXX=`which g++-10` hosacpp
conan profile update env.CC=`which gcc-10` hosacpp
```

Dodaj element zdalny narzędzia Conan przy użyciu zestawu SDK C++ platformy AWS:

```
conan remote add kmaragon https://api.bintray.com/conan/kmaragon/conan
```

### Budowanie

**Ostrzeżenie**: Budowanie zestawu SDK platformy AWS wymaga dużej ilości czasu i wielu zasobów. Jeśli masz
mniej niż 16GB pamięci RAM dostępnej na potrzeby kompilacji, kompilatorowi może jej zabraknąć. Aby temu zaradzić, możesz ograniczyć liczbę współbieżnych zadań dzięki
nadaniu zmiennej środowiskowej CONAN_CPU_COUNT wartości 1:

```
export CONAN_CPU_COUNT=1
```

Aby zbudować przykładową aplikację, wydaj polecenia:

```bash
mkdir build
cd build
conan install ../s3 --build=missing -s build_type=Release -pr=hosacpp
cmake ../s3 -DCMAKE_BUILD_TYPE=Release # typ budowy musi odpowiadać temu z narzędzia Conan
cmake --build .
```

### Uruchamianie aplikacji przykładowej

Do pomyślnego uruchomienia programu niezbędne są poprawne poświadczenia platformy AWS.

W celu uzyskania poświadczeń postępuj według wskazań dokumentu:
https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/getting-your-credentials.html
.

Jeśli tworzysz nowe konto użytkownika tylko na potrzeby testów, możesz dołączyć do niego
zasady `AdministratorAccess`. W zastosowaniach produkcyjnych nadawaj
uprawnienia w sposób precyzyjny.

Nadaj zmiennym środowiskowym wartości uzyskane z usługi IAM:

```
export AWS_ACCESS_KEY_ID="anaccesskey"
export AWS_SECRET_ACCESS_KEY="asecretkey"
```

Jeśli korzystasz z narzędzia Direnv, możesz też umieścić te zmienne w pliku `.env` w
bieżącym katalogu. Wprowadź swoje wpisy tajne do pliku `env.example` i zmień jego rozszerzenie
na `.env`.

Aplikacja tworzy na platformie AWS kubełek usługi S3.

**Ważne**: Koniecznie usuń go po
testach, bo platforma AWS naliczy opłaty. Kubełek usługi S3 możesz sprawdzić pod adresem
https://s3.console.aws.amazon.com/s3/home?region=eu-central-1# (zmień
region zgodnie z tym, który występuje w kodzie).

### Packer

Token API możesz utworzyć pod adresem
https://cloud.digitalocean.com/account/api/tokens . Potrzebny jest token z uprawnieniami
do zapisu. Skopiuj go i albo ustaw samodzielnie w zmiennej środowiskowej, albo umieść go
w pliku `.env`, jeśli korzystasz z narzędzia Direnv.

```
export DIGITALOCEAN_ACCESS_TOKEN=alongkeyhere
```

Budowanie obrazu pakietu wymaga posiadania pakietu customer-1.0.3.deb w
katalogu roboczym. Możesz albo zbudować go według instrukcji z poprzednich
rozdziałów, albo podstawić za niego inny poprawny pakiet deb, np.:

```
wget http://mirrors.kernel.org/ubuntu/pool/main/t/time/time_1.7-25.1build1_amd64.deb -O packer/customer-1.0.3.deb
```

Aby zbudować obraz za pomocą narzędzia Packer, wydaj polecenia

```
cd packer
packer build packer-digitalocean.json
```

**Ważne**: Po testach koniecznie usuń wszystkie zasoby chmury. Utworzony obraz można
znaleźć na stronie https://cloud.digitalocean.com/images/snapshots/droplets

### Przykładowe manifesty

Katalogi `kubernetes`, `rest` i `rpc` zawierają przykładowe manifesty i
dokumenty przestawione w tej książce. Mają one na celu tylko zilustrowanie tematu.
