# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 15: Projektowanie rozwiązań natywnych dla chmury

### Wymagania wstępne

Zainstaluj następujące oprogramowanie:
- CMake 3.15
- Conan 1.43
- GCC 10

Jeśli pracujesz w systemie Linux albo korzystasz z WSL, skonfiguruj profil narzędzia Conan o nazwie hosacpp i elementy zdalne przez wydanie poleceń:

```bash
conan profile new hosacpp || true
conan profile update settings.compiler=gcc hosacpp
conan profile update settings.compiler.libcxx=libstdc++11 hosacpp
conan profile update settings.compiler.version=10 hosacpp
conan profile update settings.arch=x86_64 hosacpp
conan profile update settings.os=Linux hosacpp
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 10, musisz też dodać:

```bash
conan profile update env.CXX=`which g++-10` hosacpp
conan profile update env.CC=`which gcc-10` hosacpp
```

### Budowanie

Aby zbudować przykładową aplikację jaeger-tracing, wydaj polecenia:

```bash
mkdir build
cd build
conan install ../customer --build=missing -s build_type=Release -pr=hosacpp
cmake ../customer -DCMAKE_BUILD_TYPE=Release # typ budowy musi odpowiadać temu z narzędzia Conan
cmake --build .
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 10, możesz nakazać narzędziu CMake go użyć za pomogą flagi `CMAKE_CXX_COMPILER`.
Zamień pierwsze z powyższych wywołań na:

```bash
cmake ../customer -DCMAKE_BUILD_TYPE=Release -DCMAKE_CXX_COMPILER=`which g++-10`
```
