# Skonfiguruj dostawcę AWS
provider "aws" {
  region  = var.region
  version = "~> 2.7"
}

# Zmienna wejściowa wskazująca klucz SSH, który chcemy skojarzyć z nowo 
# utworzoną maszyną
variable "public_key_path" {
  description = <<DESCRIPTION
Ścieżka do klucza publicznego SSH używanego do uwierzytelniania.
Upewnij się, że ta para kluczy jest dodana do lokalnego agenta SSH, 
aby aprowizatory mogły się połączyć.
Przykład: ~/.ssh/terraform.pub
DESCRIPTION

  default = "~/.ssh/id_rsa.pub"
}

# Zmienna wejściowa z nazwą dla klucza SSH
variable "aws_key_name" {
  description = "Pożądana nazwa pary kluczy platformy AWS"
  default     = "terraformer"
}

# Identyfikator pochodzący z wcześniejszego uruchomienia narzędzia Packer, wskazujący niestandardowy obraz bazowy 
variable "packer_ami" {
}

variable "env" {
  default = "development"
}

variable "region" {
}

# Utwórz nową parę kluczy platformy AWS zawierającą klucz publiczny jako
# zmienną wejściową
resource "aws_key_pair" "deployer" {
  key_name   = var.aws_key_name
  public_key = file(var.public_key_path)
}

# Utwórz instancję maszyny wirtualnej z niestandardowego obrazu bazowego z użyciem wcześniej 
# utworzonego klucza.
# Rozmiar maszyny wirtualnej to t2.xlarge, korzysta ona z woluminu trwałej pamięci masowej o pojemności 60 GiB,
# a dla łatwiejszego filtrowania jest otagowana.
resource "aws_instance" "project" {
  ami           = var.packer_ami
  instance_type = "t2.xlarge"
  key_name      = aws_key_pair.deployer.key_name
  root_block_device {
    volume_type = "gp2"
    volume_size = 60
  }
  tags = {
    Provider = "terraform"
    Env      = var.env
    Name     = "main-instance"
  }
}
