// Czytnik Arduino SD i szkic ADK
#include <SD.h> // musi być dołączony przed AndroidAccessory.h
#include <AndroidAccessory.h> // biblioteka wymagana przez połączenia ADK
  byte buffer[80]; 
  // zainicjowanie obiektu akcesorium danymi identyfikacyjnymi
  AndroidAccessory ADK("Producent", "Model", "Opis",
		            "2.0", "Pro Arduino", "0000000012345678");
void setup() {
  ADK.begin();  // zestawienie połączenia do urządzenia Android 
  while(!ADK.isConnected()); // oczekiwanie na połączenie ADK i zakończenie konfiguracji
  pinMode(10, OUTPUT); // wybranie układu
  if (!SD.begin(10)) {  // włączenie karty SD i sprawdzenie błędów
     ADK.println("Błąd inicjalizacji karty SD!");
  }
  else
     ADK.println("Karta SD zainicjowana.");
} // koniec setup 
void loop() {
  if (ADK.isConnected()) {   // sprawdzenie połączenia
    if (ADK.available() > 0){    // sprawdzenie przychodzących danych
      if (ADK.read() == 'a') {  // sprawdzenie, czy przyszedł znak 'a' i rozpoczęcie transmisji
         File TestFile = SD.open("test.txt");    // otwarcie pliku test.txt 
        if (TestFile) { // jeżeli plik nie jest otwarty, wywołaj błąd
           while (TestFile.available()) { // odczytanie pliku do końca
                for (int i = 0 ; i < 80 ; i ++ ){ // odczyt 80 bajtów do bufora przed wysłaniem
                buffer[i] = TestFile.read();
                }  
              ADK.write (buffer , 80); // wysłanie bufora do urządzenia Android 
           } // koniec while (TestFile.available())
          TestFile.close(); // zamknięcie pliku, nie będzie już używany 
        }  // koniec if (TestFile)
        else{ 
             ADK.println ("Błąd pliku"); 
        }
      } // koniec if (ADK.read() == 'a') 
    } // koniec if (ADK .available() > 0)
  } // koniec if (ADK .isConnected())...
} // koniec void loop()
