
#include <Wire.h>
#include "DS1631.h"


uint8_t _temp[2];
uint8_t _addr;

DS1631::DS1631(uint8_t _ADDR)
{
  // Nie mona uy tutaj funkcji Wire.begin(), poniewa na etapie deklaracji nie jest dostpna.
  // Naley przesun adres, aby uytkownik mg uy adresu podanego w dokumentacji
  _addr = _ADDR >> 1;
}

DS1631::~DS1631(){
}

void DS1631::begin()
{
}

void DS1631::stopConversion()
{
  Wire.beginTransmission(_addr);
  Wire.write(0x22); // polecenie wyczenia konwersji
  Wire.endTransmission();
}

void DS1631::startConversion()
{
  Wire.beginTransmission(_addr);
  Wire.write(0x51); // polecenie wczenia konwersji
  Wire.endTransmission();
}

byte DS1631::getConfig()
{
  byte config;

  stopConversion();
  Wire.beginTransmission(_addr);
  Wire.write(0xAC); // polecenie odczytu konfiguracji
  Wire.endTransmission();
  Wire.requestFrom(_addr, (uint8_t) 0x01); // konfiguracja zajmuje jeden bajt
  while (Wire.available())
  {
    config = Wire.read();
  }

  Wire.endTransmission();
  startConversion();
  return config;
}

void DS1631::setConfig(uint8_t config) // opcje konfiguracyjne
{
  stopConversion();
  Wire.beginTransmission(_addr);
  Wire.write(0xAC);   // polecenie odczytu konfiguracji
  Wire.write(config); // konfiguracja z opcjami
  Wire.endTransmission();
  startConversion();
}

float DS1631::getTemp() // polecenie 0xAA odczytu temperatury, odczyt 2 bajtw, pomiar pojedynczy
{
  unsigned char _temp[2];
  int count = 0;

  Wire.beginTransmission(_addr);
  Wire.write(0xAA); // pocztek odczytu temperatury
  Wire.endTransmission();

  delay(750); // wymagana zwoka 750 ms przy 12-bitowej dokadnoci odczytu temperatury
  Wire.requestFrom(_addr,  (uint8_t)2); // odczyt 2-bajtowej wartoci
  while(Wire.available())
  {
    _temp[count] = Wire.read();
    count++;
  }
  float temp = calcTemp(_temp[0],_temp[1]);
  return temp;
}

float DS1631::calcTemp(int msb,  int lsb)
{
  float num = 0.0;
  // dopuszczalne, ale tylko 2  3 znaczce bity
  // num = ((((short)msb<<8) | (short)lsb)>>6) / 4.0;  
  lsb = lsb >> 4; // wysunicie ostatnich 4 bitw, poniewa s rwne 0
  if (msb & 0x80) // sprawdzenie, czy bit znaku = 1, utworzenie liczby ujemnej
  {
    msb = msb - 256;
  }
  // konwersja zmiennoprzecinkowa
  num = (float) (msb + lsb*0.0625);
  return  num;
}





