/*
*
 * Obiekt biblioteki DS1631
 * Wykorzystane artykuy:
 * http://www.maxim-ic.com/app-notes/index.mvp/id/135
 * http://www.arduino.cc/cgi-bin/yabb2/YaBB.pl?num=1221926830
 * http://www.peyregne.info/wp/?p=211
 *
 * Rejestry R1 i R2 s uywane do ustawienia bitw 9, 10, 11, 12 do pomiaru temperatury
 * w zakresie 55 C do +125 C
 * Rejestry A0, A1, A2 s uywane do ustawienia adresu urzdzenia, przesuwanego przez funkcje biblioteki
 * Mona skonfigurowa pomiar pojedynczy lub cigy.
 * Przy dokadnoci 12-bitowej odczyt trwa 750 ms
 * Temperatura jest zwracana jako rejestr 16-bitowy, zoony z dwch czci: Th i Tl
 * Bit znaku S = 0 oznacza temperatur dodatni, S = 1 ujemn
 */
 
#ifndef DS1631_h
#define DS1631_h

#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#include "pins_arduino.h"
#else
#include "WProgram.h"
#include "pins_arduino.h"
#endif

#define DEV0 0x90
#define DEV1 0x91
#define DEV2 0x92
#define DEV3 0x93
#define DEV4 0x94
#define DEV5 0x95
#define DEV6 0x96
#define DEV7 0x97

class DS1631 
{
public:

  DS1631(uint8_t _ADDR);
  ~DS1631();
  void begin( );
  byte getConfig();
  void setConfig(uint8_t _ADDR);
  float getTemp();
  void stopConversion();
  void startConversion();

  // Do srobienia:
  uint8_t getTripHigh();
  void setTripHigh(uint8_t _ADDR);
  uint8_t getTripLow();
  void setTripLow(uint8_t _ADDR);

private:  
  float calcTemp(int msb,  int lsb);
  uint8_t _addr;
  uint8_t _temp[2];
};
#endif





