// Listing 10.3. Szkic kodu ustawiajcego tryb master w rejestrze
const int bufferSize = 64; // ustawienie wielkoci buforw txBuffer oraz rxBuffer
byte txBuffer[bufferSize]; // bufor na dane oczekujce na wysanie do urzdzenia slave
byte rxBuffer[bufferSize]; // bufor na dane odebrane z urzdzenia slave

void setup() {
  Serial.begin(115200);
  DDRB |= 0b00101101;  // wyjcie LED(8) MOSI SCK SS
  PORTB |= 0b00000100; // ustawienie stanu wysokiego na SS
  SPCR |= 0b01010000;  // rejestr sterujcy SPI; bit SPE (nr 6) wcza SPI, a MSTR (bit 4) ustawia urzdzenie jako master
  SPSR |= 0b00000000;  // domylne ustawienia SPI i przerwa
}
void loop() {
  if (Serial.available() > 0) {
    int count = 0;
    delay(50); // zwoka na ukoczenie odbioru na porcie szeregowym 
      while (Serial.available() > 0) {
        txBuffer[count] = Serial.read(); // zapisanie bufora portu szeregowego do txBuffer
        count++;  
      }
    PORTB &= 0b11111011; // wczenie sygnau SS
    transferSPI(count);
    PORTB |= 0b00000100; // wyczenie sygnau SS
  }
  // miganie diody
  PORTB |= 0b00000001;
  delay(1000);              // oczekiwanie 1 s
  PORTB &= 0b11111110;
  delay(1000);              // oczekiwanie 1 s
}
int transferSPI(int txBytes) { 
  int count = 0;
    while (count < txBytes) {
      SPDR = txBuffer[count]; // zapis do rejestru rozpoczyna transmisj SPI
      while (!(SPSR & (1 << SPIF))); // oczekiwanie na skoczenie transmisji
      rxBuffer[count] = SPDR; // odczyt odebranego pakietu
      count++;
    }
  displayBuffer(count);  
}
int displayBuffer(int nBytes) { // wywietlenie buforw txBuffer i rxBuffer na ekranie
  Serial.write (txBuffer, nBytes);
  Serial.println();
  Serial.write (rxBuffer, nBytes);
  Serial.println();
}
