/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.ArrayList;
import org.achartengine.chart.PieMapper;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;

public class PieChart
extends RoundChart {
    private PieMapper mPieMapper = new PieMapper();

    public PieChart(CategorySeries dataset, DefaultRenderer renderer) {
        super(dataset, renderer);
    }

    @Override
    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        boolean loadPieCfg;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, 0.0f);
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        float currentAngle = 0.0f;
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (left + right) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (bottom + top) / 2;
        }
        this.mPieMapper.setDimensions(radius, this.mCenterX, this.mCenterY);
        boolean bl = loadPieCfg = !this.mPieMapper.areAllSegmentPresent(sLength);
        if (loadPieCfg) {
            this.mPieMapper.clearPieSegments();
        }
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        RectF oval = new RectF((float)(this.mCenterX - radius), (float)(this.mCenterY - radius), (float)(this.mCenterX + radius), (float)(this.mCenterY + radius));
        ArrayList<RectF> prevLabelsBounds = new ArrayList<RectF>();
        for (int i = 0; i < sLength; ++i) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            float value = (float)this.mDataset.getValue(i);
            float angle = (float)((double)value / total * 360.0);
            canvas.drawArc(oval, currentAngle, angle, true, paint);
            this.drawLabel(canvas, this.mDataset.getCategory(i), this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius, longRadius, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint);
            if (loadPieCfg) {
                this.mPieMapper.addPieSegment(i, value, currentAngle, angle);
            }
            currentAngle += angle;
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
        this.drawTitle(canvas, x, y, width, paint);
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        return this.mPieMapper.getSeriesAndPointForScreenCoordinate(screenPoint);
    }
}

