/* Projekt nr 60  budowa zdalnej stacji monitoringu
   Szkic utworzony 18 grudnia 2009 przez Davida A. Mellisa; zmodyfikowany 9 kwietnia 2012 przez Toma Igoe;
   zmodyfikowany 20 marca 2013 przez Johna Boxalla
*/

#include <SPI.h>
#include <Ethernet.h>

IPAddress ip(xxx,xxx,xxx,xxx); // W tym miejscu naley wpisa odpowiedni adres IP
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
EthernetServer server(80);

void setup()
{
   // Uruchamia poczenie sieciowe i sam serwer
   Ethernet.begin(mac, ip);
   server.begin();
   for (int z=0; z<10; z++)
   {
      pinMode(z, INPUT); // ustawia piny cyfrowe od 0 do 9 jako piny wejciowe
   }
}

void loop()
{
   // nasuchuje da klientw (przychodzcych da pobrania strony)
   EthernetClient client = server.available();
   if (client) {
      // danie HTTP koczy si pustym wierszem
      boolean currentLineIsBlank = true;
      while (client.connected()) {
         if (client.available()) {
            char c = client.read();
            if (c == '\n' && currentLineIsBlank) {
               client.println("HTTP/1.1 200 OK");
               client.println("Content-Type: text/html");
               client.println("Connection: close");
               client.println();
               client.println("<!DOCTYPE HTML>");
               client.println("<html>");
               // dodaje znacznik meta refresh, aby przegldarka odwieaa stron co 5 sekund:
               client.println("<meta http-equiv=\"refresh\" content=\"5\">");
               // umieszcza na stronie wartoci poszczeglnych wejciowych pinw analogowych
               for (int analogChannel = 0; analogChannel < 6; analogChannel++) {
                  int sensorReading = analogRead(analogChannel);
                  client.print("stan wejciowego pinu analogowego ");
                  client.print(analogChannel);
                  client.print(" to ");
                  client.print(sensorReading);
                  client.println("<br />");
               }
               // umieszcza na stronie wartoci pinw cyfrowych od 0 do 9
               for (int digitalChannel = 0; digitalChannel < 10; digitalChannel++)
               {
                  boolean pinStatus = digitalRead(digitalChannel);
                  client.print("pin cyfrowy nr ");
                  client.print(digitalChannel);
                  client.print(" ma warto ");
                  client.print(pinStatus);
                  client.println("<br />");
               }
               client.println("</html>");
               break;
            }
            if (c == '\n') {
               // pocztek nowego wiersza
               currentLineIsBlank = true;
            }
            else if (c != '\r') {
               // otrzymano znak w biecym wierszu
               currentLineIsBlank = false;
            }
         }
      }
      // przegldarka WWW potrzebuje czasu na odebranie danych
      delay(1);
      // zamyka poczenie:
      client.stop();
   }
}
