// Projekt nr 46  rejestrowanie pooenia ruchomego obiektu w czasie
#include <SD.h>
#include <TinyGPS.h>

// Tworzy obiekt typu TinyGPS:
TinyGPS gps;

void getgps(TinyGPS &gps);

void setup()
{
   pinMode(10, OUTPUT);
   Serial.begin(9600);
   // sprawdza, czy karta microSD jest dostpna i gotowa do uycia
   if (!SD.begin(8)) {
      Serial.println("Brak lub nieprawidowe dziaanie karty");
      // zatrzymuje wykonywanie szkicu
      return;
   }
   Serial.println("Karta microSD jest gotowa");
}

void getgps(TinyGPS &gps)
{
   float latitude, longitude;
   int year;
   byte month, day, hour, minute, second, hundredths;

   // dekoduje i wywietla biec pozycj
   gps.f_get_position(&latitude, &longitude);
   File dataFile = SD.open("DATA.TXT", FILE_WRITE);
   // jeli plik jest gotowy, zapisuje dane
   if (dataFile)
   {
      dataFile.print("Szer: ");
      dataFile.print(latitude,5);
      dataFile.print(" ");
      dataFile.print("Dug: ");
      dataFile.print(longitude,5);
      dataFile.print(" ");
      // dekoduje i wywietla biec dat i godzin
      gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);
      // korekta strefy czasowej (tak jak w projekcie nr 45)
      hour=hour+1;
      if (hour>23)
      {
         hour=hour-24;
      }
      if (hour<10)
      {
         dataFile.print("0");
      }
      dataFile.print(hour, DEC);
      dataFile.print(":");
      if (minute<10)
      {
         dataFile.print("0");
      }
      dataFile.print(minute, DEC);
      dataFile.print(":");
      if (second<10)
      {
         dataFile.print("0");
      }
      dataFile.print(second, DEC);
      dataFile.print(" ");
      dataFile.print(gps.f_speed_kmph());
      dataFile.println(" km/h");
      dataFile.close();
      delay(30000); // rejestruje dane co 30 sekund
   }
}

void loop()
{
   byte a;
   if ( Serial.available() > 0 ) // jeli otrzymano dane za porednictwem portu szeregowego...
   {
      a = Serial.read(); // ...pobiera bajt danych
      if(gps.encode(a)) // jeli otrzymano prawidowe dane GPS...
      {
         getgps(gps); // ...pobiera te dane i wywietla je na ekranie LCD
      }
   }
}
