// Projekt nr 31  budowa stopera

unsigned long start, finished, elapsed;

void setup()
{
   Serial.begin(9600);
   pinMode(2, INPUT); // przycisk Start
   pinMode(3, INPUT); // przycisk Stop
   Serial.println("Nacinij 1, aby uruchomi/wyzerowa stoper; nacinij przycisk 2, aby wywietli zmierzony czas");
}

void displayResult()
{
   float h, m, s, ms;
   unsigned long over;

   elapsed = finished - start;

   h    = int(elapsed / 3600000);
   over = elapsed % 3600000;
   m    = int(over / 60000);
   over = over % 60000;
   s    = int(over / 1000);
   ms   = over % 1000;

   Serial.print("Zmierzony czas (milisekundy): ");
   Serial.println(elapsed);
   Serial.print("Zmierzony czas: ");
   Serial.print(h, 0);
   Serial.print(" h ");
   Serial.print(m, 0);
   Serial.print(" min ");
   Serial.print(s, 0);
   Serial.print(" s ");
   Serial.print(ms, 0);
   Serial.println(" ms");
   Serial.println();
}

void loop()
{
   if (digitalRead(2) == HIGH)
   {
      start = millis();
      delay(200); // zabezpieczenie przed drganiem stykw
      Serial.println("Uruchomiono stoper...");
   }
   if (digitalRead(3) == HIGH)
   {
      finished = millis();
      delay(200); // zabezpieczenie przed drganiem stykw
      displayResult();
   }
}
